/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Destroyable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.DocumentedDefinition;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.eclipse.leshan.client.LeshanClient;
import org.eclipse.leshan.client.LeshanClientBuilder;
import org.eclipse.leshan.client.californium.endpoint.CaliforniumClientEndpointsProvider;
import org.eclipse.leshan.client.californium.endpoint.ClientProtocolProvider;
import org.eclipse.leshan.client.californium.endpoint.coap.CoapOscoreProtocolProvider;
import org.eclipse.leshan.client.californium.endpoint.coaps.CoapsClientProtocolProvider;
import org.eclipse.leshan.client.endpoint.LwM2mClientEndpointsProvider;
import org.eclipse.leshan.client.engine.DefaultRegistrationEngineFactory;
import org.eclipse.leshan.client.engine.RegistrationEngineFactory;
import org.eclipse.leshan.client.object.Security;
import org.eclipse.leshan.client.object.Server;
import org.eclipse.leshan.client.observer.LwM2mClientObserver;
import org.eclipse.leshan.client.resource.BaseInstanceEnabler;
import org.eclipse.leshan.client.resource.DummyInstanceEnabler;
import org.eclipse.leshan.client.resource.LwM2mInstanceEnabler;
import org.eclipse.leshan.client.resource.ObjectsInitializer;
import org.eclipse.leshan.client.servers.LwM2mServer;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.model.InvalidDDFFileException;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.model.ObjectLoader;
import org.eclipse.leshan.core.model.ObjectModel;
import org.eclipse.leshan.core.model.StaticModel;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mDecoder;
import org.eclipse.leshan.core.node.codec.DefaultLwM2mEncoder;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.node.codec.LwM2mEncoder;
import org.eclipse.leshan.core.request.BootstrapRequest;
import org.eclipse.leshan.core.request.DeregisterRequest;
import org.eclipse.leshan.core.request.RegisterRequest;
import org.eclipse.leshan.core.request.UpdateRequest;
import org.eclipse.leshan.core.response.ReadResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.monitoring.util.ResourceUtils;

public class Lwm2mClient
extends BaseInstanceEnabler
implements Destroyable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Lwm2mClient.class);
    private LeshanClient leshanClient;
    private static final List<Integer> supportedResources = List.of(Integer.valueOf(0), Integer.valueOf(16));
    private String data = "";
    private String serverUri;
    private String endpoint;

    public Lwm2mClient(String serverUri, String endpoint) {
        this.serverUri = serverUri;
        this.endpoint = endpoint;
    }

    public Lwm2mClient() {
    }

    public void initClient() throws InvalidDDFFileException, IOException {
        String[] resources = new String[]{"0.xml", "1.xml", "2.xml", "test-model.xml"};
        ArrayList models = new ArrayList();
        for (String resourceName : resources) {
            models.addAll(ObjectLoader.loadDdfFile((InputStream)ResourceUtils.getResourceAsStream("lwm2m/models/" + resourceName), (String)resourceName));
        }
        Security security = Security.noSec((String)this.serverUri, (int)123);
        Configuration coapConfig = new Configuration();
        String portStr = StringUtils.substringAfterLast((String)this.serverUri, (String)":");
        if (StringUtils.isNotEmpty((CharSequence)portStr)) {
            coapConfig.set((BasicDefinition)CoapConfig.COAP_PORT, (Object)Integer.parseInt(portStr));
        }
        StaticModel model = new StaticModel(models);
        ObjectsInitializer initializer = new ObjectsInitializer((LwM2mModel)model);
        initializer.setInstancesForObject(0, new LwM2mInstanceEnabler[]{security});
        initializer.setInstancesForObject(1, new LwM2mInstanceEnabler[]{new Server(123, TimeUnit.MINUTES.toSeconds(5L))});
        initializer.setInstancesForObject(3, new LwM2mInstanceEnabler[]{this});
        initializer.setClassForObject(2, DummyInstanceEnabler.class);
        ArrayList<Object> protocolProvider = new ArrayList<Object>();
        protocolProvider.add(new CoapOscoreProtocolProvider());
        protocolProvider.add(new CoapsClientProtocolProvider());
        CaliforniumClientEndpointsProvider.Builder endpointsBuilder = new CaliforniumClientEndpointsProvider.Builder(protocolProvider.toArray(new ClientProtocolProvider[protocolProvider.size()]));
        Configuration clientCoapConfig = endpointsBuilder.createDefaultConfiguration();
        clientCoapConfig.setTransient((DocumentedDefinition)DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY);
        clientCoapConfig.set((BasicDefinition)DtlsConfig.DTLS_RECOMMENDED_CIPHER_SUITES_ONLY, (Object)true);
        endpointsBuilder.setConfiguration(clientCoapConfig);
        ArrayList<CaliforniumClientEndpointsProvider> endpointsProvider = new ArrayList<CaliforniumClientEndpointsProvider>();
        endpointsProvider.add(endpointsBuilder.build());
        DefaultRegistrationEngineFactory engineFactory = new DefaultRegistrationEngineFactory();
        engineFactory.setReconnectOnUpdate(false);
        engineFactory.setResumeOnConnect(true);
        LeshanClientBuilder builder = new LeshanClientBuilder(this.endpoint);
        builder.setObjects(initializer.createAll());
        builder.setEndpointsProviders(endpointsProvider.toArray(new LwM2mClientEndpointsProvider[endpointsProvider.size()]));
        builder.setRegistrationEngineFactory((RegistrationEngineFactory)engineFactory);
        builder.setDecoder((LwM2mDecoder)new DefaultLwM2mDecoder(false));
        builder.setEncoder((LwM2mEncoder)new DefaultLwM2mEncoder(false));
        this.leshanClient = builder.build();
        LwM2mClientObserver observer = new LwM2mClientObserver(){

            public void onBootstrapStarted(LwM2mServer bsserver, BootstrapRequest request) {
            }

            public void onBootstrapSuccess(LwM2mServer bsserver, BootstrapRequest request) {
            }

            public void onBootstrapFailure(LwM2mServer bsserver, BootstrapRequest request, ResponseCode responseCode, String errorMessage, Exception cause) {
                log.debug("onBootstrapFailure [{}] [{}] [{}]", new Object[]{request.getEndpointName(), responseCode, errorMessage});
            }

            public void onBootstrapTimeout(LwM2mServer bsserver, BootstrapRequest request) {
            }

            public void onRegistrationStarted(LwM2mServer server, RegisterRequest request) {
                log.debug("onRegistrationStarted [{}]", (Object)request.getEndpointName());
            }

            public void onRegistrationSuccess(LwM2mServer server, RegisterRequest request, String registrationID) {
                log.debug("onRegistrationSuccess [{}] [{}]", (Object)request.getEndpointName(), (Object)registrationID);
            }

            public void onRegistrationFailure(LwM2mServer server, RegisterRequest request, ResponseCode responseCode, String errorMessage, Exception cause) {
                log.debug("onRegistrationFailure [{}] [{}] [{}]", new Object[]{request.getEndpointName(), responseCode, errorMessage});
            }

            public void onRegistrationTimeout(LwM2mServer server, RegisterRequest request) {
                log.debug("onRegistrationTimeout [{}]", (Object)request.getEndpointName());
            }

            public void onUpdateStarted(LwM2mServer server, UpdateRequest request) {
                log.debug("onUpdateStarted [{}]", (Object)request.getRegistrationId());
            }

            public void onUpdateSuccess(LwM2mServer server, UpdateRequest request) {
                log.debug("onUpdateSuccess [{}]", (Object)request.getRegistrationId());
            }

            public void onUpdateFailure(LwM2mServer server, UpdateRequest request, ResponseCode responseCode, String errorMessage, Exception cause) {
                log.debug("onUpdateFailure [{}]", (Object)request.getRegistrationId());
            }

            public void onUpdateTimeout(LwM2mServer server, UpdateRequest request) {
                log.debug("onUpdateTimeout [{}]", (Object)request.getRegistrationId());
            }

            public void onDeregistrationStarted(LwM2mServer server, DeregisterRequest request) {
                log.debug("onDeregistrationStarted [{}]", (Object)request.getRegistrationId());
            }

            public void onDeregistrationSuccess(LwM2mServer server, DeregisterRequest request) {
                log.debug("onDeregistrationSuccess [{}]", (Object)request.getRegistrationId());
            }

            public void onDeregistrationFailure(LwM2mServer server, DeregisterRequest request, ResponseCode responseCode, String errorMessage, Exception cause) {
                log.debug("onDeregistrationFailure [{}] [{}] [{}]", new Object[]{request.getRegistrationId(), responseCode, errorMessage});
            }

            public void onDeregistrationTimeout(LwM2mServer server, DeregisterRequest request) {
                log.debug("onDeregistrationTimeout [{}]", (Object)request.getRegistrationId());
            }

            public void onUnexpectedError(Throwable unexpectedError) {
                log.debug("onUnexpectedError [{}]", (Object)unexpectedError.toString());
            }
        };
        this.leshanClient.addObserver(observer);
        this.setLeshanClient(this.leshanClient);
        this.leshanClient.start();
    }

    public List<Integer> getAvailableResourceIds(ObjectModel model) {
        return supportedResources;
    }

    public ReadResponse read(LwM2mServer server, int resourceId) {
        return switch (resourceId) {
            case 0 -> ReadResponse.success((int)0, (String)this.data);
            case 16 -> ReadResponse.success((int)16, (String)"U");
            default -> super.read(server, resourceId);
        };
    }

    public void send(String data, int resource) {
        this.data = data;
        this.fireResourceChange(resource);
    }

    @Override
    public void destroy() {
        if (this.leshanClient != null) {
            this.leshanClient.destroy(true);
        }
    }

    @Generated
    public LeshanClient getLeshanClient() {
        return this.leshanClient;
    }

    @Generated
    public void setLeshanClient(LeshanClient leshanClient) {
        this.leshanClient = leshanClient;
    }
}

