/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.monitoring.client.TbClient;
import org.thingsboard.monitoring.data.Latency;
import org.thingsboard.monitoring.data.notification.HighLatencyNotification;
import org.thingsboard.monitoring.data.notification.Notification;
import org.thingsboard.monitoring.data.notification.ServiceFailureNotification;
import org.thingsboard.monitoring.data.notification.ServiceRecoveryNotification;
import org.thingsboard.monitoring.notification.NotificationService;
import org.thingsboard.monitoring.service.MonitoringEntityService;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.EntityId;

@Component
public class MonitoringReporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoringReporter.class);
    private final NotificationService notificationService;
    private final TbClient tbClient;
    private final MonitoringEntityService entityService;
    private final Map<String, Latency> latencies = new ConcurrentHashMap();
    private final Map<Object, AtomicInteger> failuresCounters = new ConcurrentHashMap();
    @Value(value="${monitoring.failures_threshold}")
    private int failuresThreshold;
    @Value(value="${monitoring.repeated_failure_notification}")
    private int repeatedFailureNotification;
    @Value(value="${monitoring.latency.enabled}")
    private boolean latencyReportingEnabled;
    @Value(value="${monitoring.latency.threshold_ms}")
    private int latencyThresholdMs;
    @Value(value="${monitoring.latency.reporting_asset_id}")
    private String reportingAssetId;

    public void reportLatencies() {
        if (this.latencies.isEmpty()) {
            return;
        }
        log.debug("Latencies:\n{}", (Object)(this.latencies.values().stream().map(latency -> latency.getKey() + ": " + latency.getFormattedValue()).collect(Collectors.joining("\n")) + "\n"));
        if (!this.latencyReportingEnabled) {
            return;
        }
        List highLatencies = this.latencies.values().stream().filter(latency -> latency.getValue() >= (double)this.latencyThresholdMs).collect(Collectors.toList());
        if (!highLatencies.isEmpty()) {
            HighLatencyNotification highLatencyNotification = new HighLatencyNotification(highLatencies, this.latencyThresholdMs);
            this.notificationService.sendNotification((Notification)highLatencyNotification);
            log.warn("{}", (Object)highLatencyNotification.getText());
        }
        try {
            if (StringUtils.isBlank((CharSequence)this.reportingAssetId)) {
                Asset monitoringAsset = this.entityService.getOrCreateMonitoringAsset();
                this.reportingAssetId = monitoringAsset.getId().toString();
            }
            ObjectNode msg = JacksonUtil.newObjectNode();
            this.latencies.values().forEach(latency -> msg.set(latency.getKey(), (JsonNode)new DoubleNode(latency.getValue())));
            this.tbClient.saveEntityTelemetry((EntityId)new AssetId(UUID.fromString(this.reportingAssetId)), "time", (JsonNode)msg);
            this.latencies.clear();
        }
        catch (Exception e) {
            log.error("Failed to report latencies: {}", (Object)e.getMessage());
        }
    }

    public void reportLatency(String key, long latencyInNanos) {
        String latencyKey = key + "Latency";
        double latencyInMs = (double)latencyInNanos / 1000000.0;
        log.trace("Reporting latency [{}]: {} ms", (Object)key, (Object)latencyInMs);
        this.latencies.put(latencyKey, Latency.of((String)latencyKey, (double)latencyInMs));
    }

    public void serviceFailure(Object serviceKey, Throwable error) {
        if (log.isDebugEnabled()) {
            log.error("[{}] Error occurred", serviceKey, (Object)error);
        }
        int failuresCount = this.failuresCounters.computeIfAbsent(serviceKey, k -> new AtomicInteger()).incrementAndGet();
        ServiceFailureNotification notification = new ServiceFailureNotification(serviceKey, error, failuresCount);
        log.error(notification.getText());
        if (failuresCount == this.failuresThreshold || this.repeatedFailureNotification != 0 && failuresCount % this.repeatedFailureNotification == 0) {
            this.notificationService.sendNotification((Notification)notification);
        }
    }

    public void serviceIsOk(Object serviceKey) {
        AtomicInteger failuresCounter;
        ServiceRecoveryNotification notification = new ServiceRecoveryNotification(serviceKey);
        if (!serviceKey.equals("Monitoring")) {
            log.info(notification.getText());
        }
        if ((failuresCounter = (AtomicInteger)this.failuresCounters.get(serviceKey)) != null) {
            if (failuresCounter.get() >= this.failuresThreshold) {
                this.notificationService.sendNotification((Notification)notification);
            }
            failuresCounter.set(0);
        }
    }

    @ConstructorProperties(value={"notificationService", "tbClient", "entityService"})
    @Generated
    public MonitoringReporter(NotificationService notificationService, TbClient tbClient, MonitoringEntityService entityService) {
        this.notificationService = notificationService;
        this.tbClient = tbClient;
        this.entityService = entityService;
    }
}

