/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.client;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.net.ssl.SSLParameters;
import lombok.Generated;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.monitoring.data.cmd.CmdsWrapper;
import org.thingsboard.monitoring.data.cmd.EntityDataCmd;
import org.thingsboard.monitoring.data.cmd.EntityDataUpdate;
import org.thingsboard.monitoring.data.cmd.LatestValueCmd;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.EntityListFilter;

public class WsClient
extends WebSocketClient
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WsClient.class);
    public final List<JsonNode> lastMsgs = new ArrayList();
    private CountDownLatch reply;
    private CountDownLatch update;
    private final Lock updateLock = new ReentrantLock();
    private final long requestTimeoutMs;

    public WsClient(URI serverUri, long requestTimeoutMs) {
        super(serverUri);
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void onOpen(ServerHandshake serverHandshake) {
    }

    public void onMessage(String s) {
        if (s == null) {
            return;
        }
        this.updateLock.lock();
        try {
            JsonNode msg = JacksonUtil.toJsonNode((String)s);
            this.lastMsgs.add(msg);
            log.trace("Received new msg: {}", (Object)msg.toPrettyString());
            if (this.update != null) {
                this.update.countDown();
            }
            if (this.reply != null) {
                this.reply.countDown();
            }
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public void onClose(int i, String s, boolean b) {
        log.debug("WebSocket client is closed");
    }

    public void onError(Exception e) {
        log.error("WebSocket client error:", (Throwable)e);
    }

    public void registerWaitForUpdates(int count) {
        this.updateLock.lock();
        try {
            this.lastMsgs.clear();
            this.update = new CountDownLatch(count);
        }
        finally {
            this.updateLock.unlock();
        }
        log.trace("Registered wait for update");
    }

    public void send(String text) throws NotYetConnectedException {
        this.updateLock.lock();
        try {
            this.lastMsgs.clear();
            this.reply = new CountDownLatch(1);
        }
        finally {
            this.updateLock.unlock();
        }
        super.send(text);
    }

    public WsClient subscribeForTelemetry(List<UUID> devices, List<String> keys) {
        EntityDataCmd cmd = new EntityDataCmd();
        cmd.setCmdId(RandomUtils.nextInt((int)0, (int)1000));
        EntityListFilter devicesFilter = new EntityListFilter();
        devicesFilter.setEntityType(EntityType.DEVICE);
        devicesFilter.setEntityList(devices.stream().map(UUID::toString).collect(Collectors.toList()));
        EntityDataPageLink pageLink = new EntityDataPageLink(100, 0, null, null);
        EntityDataQuery devicesQuery = new EntityDataQuery((EntityFilter)devicesFilter, pageLink, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        cmd.setQuery(devicesQuery);
        LatestValueCmd latestCmd = new LatestValueCmd();
        latestCmd.setKeys(keys.stream().map(key -> new EntityKey(EntityKeyType.TIME_SERIES, key)).toList());
        cmd.setLatestCmd(latestCmd);
        CmdsWrapper wrapper = new CmdsWrapper();
        wrapper.setEntityDataCmds(List.of(cmd));
        this.send(JacksonUtil.toString((Object)wrapper));
        return this;
    }

    public List<JsonNode> waitForUpdates(long ms) {
        log.trace("update latch count: {}", (Object)this.update.getCount());
        try {
            if (this.update.await(ms, TimeUnit.MILLISECONDS)) {
                log.trace("Waited for update");
                return this.getLastMsgs();
            }
        }
        catch (InterruptedException e) {
            log.debug("Failed to await reply", (Throwable)e);
        }
        log.trace("No update arrived within {} ms", (Object)ms);
        return null;
    }

    public JsonNode waitForReply() {
        try {
            if (this.reply.await(this.requestTimeoutMs, TimeUnit.MILLISECONDS)) {
                log.trace("Waited for reply");
                List lastMsgs = this.getLastMsgs();
                return lastMsgs.isEmpty() ? null : (JsonNode)lastMsgs.get(0);
            }
        }
        catch (InterruptedException e) {
            log.debug("Failed to await reply", (Throwable)e);
        }
        log.trace("No reply arrived within {} ms", (Object)this.requestTimeoutMs);
        throw new IllegalStateException("No WS reply arrived within " + this.requestTimeoutMs + " ms");
    }

    private List<JsonNode> getLastMsgs() {
        if (this.lastMsgs.isEmpty()) {
            return this.lastMsgs;
        }
        List<JsonNode> errors = this.lastMsgs.stream().map(msg -> msg.get("errorMsg")).filter(errorMsg -> errorMsg != null && !errorMsg.isNull() && StringUtils.isNotEmpty((CharSequence)errorMsg.asText())).toList();
        if (!errors.isEmpty()) {
            throw new RuntimeException("WS error from server: " + errors.stream().map(JsonNode::asText).collect(Collectors.joining(", ")));
        }
        return this.lastMsgs;
    }

    public Map<String, String> getLatest(UUID deviceId) {
        HashMap<String, String> updates = new HashMap<String, String>();
        this.getLastMsgs().forEach(msg -> {
            EntityDataUpdate update = (EntityDataUpdate)JacksonUtil.treeToValue((JsonNode)msg, EntityDataUpdate.class);
            Map latest = update.getLatest(deviceId);
            updates.putAll(latest);
        });
        return updates;
    }

    protected void onSetSSLParameters(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm(null);
    }
}

