/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.thingsboard.common.util.ThingsBoardExecutors;
import org.thingsboard.monitoring.service.BaseMonitoringService;
import org.thingsboard.monitoring.service.MonitoringEntityService;

@SpringBootApplication
@EnableScheduling
public class ThingsboardMonitoringApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThingsboardMonitoringApplication.class);
    @Autowired
    private List<BaseMonitoringService<?, ?>> monitoringServices;
    @Autowired
    private MonitoringEntityService entityService;
    @Value(value="${monitoring.monitoring_rate_ms}")
    private int monitoringRateMs;

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{ThingsboardMonitoringApplication.class}).properties(Map.of("spring.config.name", "tb-monitoring")).run(args);
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void startMonitoring() {
        this.entityService.checkEntities();
        this.monitoringServices.forEach(BaseMonitoringService::init);
        ScheduledExecutorService scheduler = ThingsBoardExecutors.newSingleThreadScheduledExecutor((String)"monitoring-executor");
        scheduler.scheduleWithFixedDelay(() -> this.monitoringServices.forEach(monitoringService -> monitoringService.runChecks()), 0L, this.monitoringRateMs, TimeUnit.MILLISECONDS);
    }
}

