/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import org.thingsboard.common.util.JacksonUtil;

public class ResourceUtils {
    public static <T> T getResource(String path, Class<T> type) {
        InputStream resource = ResourceUtils.getResourceStream(path);
        return (T)JacksonUtil.OBJECT_MAPPER.readValue(resource, type);
    }

    public static JsonNode getResource(String path) {
        InputStream resource = ResourceUtils.getResourceStream(path);
        return JacksonUtil.OBJECT_MAPPER.readTree(resource);
    }

    public static InputStream getResourceAsStream(String path) {
        return ResourceUtils.getResourceStream(path);
    }

    private static InputStream getResourceStream(String path) {
        InputStream resource = ResourceUtils.class.getClassLoader().getResourceAsStream(path);
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found for path " + path);
        }
        return resource;
    }
}

