/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.transport.impl;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.thingsboard.monitoring.client.Lwm2mClient;
import org.thingsboard.monitoring.config.transport.Lwm2mTransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringTarget;
import org.thingsboard.monitoring.config.transport.TransportType;
import org.thingsboard.monitoring.service.transport.TransportHealthChecker;

@Service
@Scope(value="prototype")
public class Lwm2mTransportHealthChecker
extends TransportHealthChecker<Lwm2mTransportMonitoringConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Lwm2mTransportHealthChecker.class);
    private Lwm2mClient lwm2mClient;

    protected Lwm2mTransportHealthChecker(Lwm2mTransportMonitoringConfig config, TransportMonitoringTarget target) {
        super(config, target);
    }

    @Override
    protected void initClient() throws Exception {
        if (this.lwm2mClient == null || this.lwm2mClient.getLeshanClient() == null || this.lwm2mClient.isDestroyed()) {
            String endpoint = ((TransportMonitoringTarget)this.target).getDevice().getCredentials().getCredentialsId();
            this.lwm2mClient = new Lwm2mClient(((TransportMonitoringTarget)this.target).getBaseUrl(), endpoint);
            this.lwm2mClient.initClient();
            log.debug("Initialized LwM2M client for endpoint '{}'", (Object)endpoint);
        }
    }

    @Override
    protected void sendTestPayload(String payload) throws Exception {
        this.lwm2mClient.send(payload, 0);
    }

    @Override
    protected String createTestPayload(String testValue) {
        return testValue;
    }

    @Override
    protected void destroyClient() throws Exception {
        if (this.lwm2mClient != null) {
            this.lwm2mClient.destroy();
            this.lwm2mClient = null;
        }
    }

    @Override
    protected TransportType getTransportType() {
        return TransportType.LWM2M;
    }
}

