/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service;

import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.thingsboard.monitoring.client.TbClient;
import org.thingsboard.monitoring.client.WsClient;
import org.thingsboard.monitoring.client.WsClientFactory;
import org.thingsboard.monitoring.config.MonitoringConfig;
import org.thingsboard.monitoring.config.MonitoringTarget;
import org.thingsboard.monitoring.data.ServiceFailureException;
import org.thingsboard.monitoring.service.BaseHealthChecker;
import org.thingsboard.monitoring.service.MonitoringReporter;
import org.thingsboard.monitoring.util.TbStopWatch;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.query.EntityDataPageLink;
import org.thingsboard.server.common.data.query.EntityDataQuery;
import org.thingsboard.server.common.data.query.EntityDataSortOrder;
import org.thingsboard.server.common.data.query.EntityFilter;
import org.thingsboard.server.common.data.query.EntityKey;
import org.thingsboard.server.common.data.query.EntityKeyType;
import org.thingsboard.server.common.data.query.EntityTypeFilter;
import org.thingsboard.server.common.data.query.TsValue;

public abstract class BaseMonitoringService<C extends MonitoringConfig<T>, T extends MonitoringTarget> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseMonitoringService.class);
    @Autowired(required=false)
    private List<C> configs;
    private final List<BaseHealthChecker<C, T>> healthCheckers = new LinkedList<BaseHealthChecker<C, T>>();
    private final List<UUID> devices = new LinkedList<UUID>();
    @Autowired
    private TbClient tbClient;
    @Autowired
    private WsClientFactory wsClientFactory;
    @Autowired
    private TbStopWatch stopWatch;
    @Autowired
    private MonitoringReporter reporter;
    @Autowired
    protected ApplicationContext applicationContext;
    @Value(value="${monitoring.edqs.enabled:false}")
    private boolean checkEdqs;
    @Value(value="${monitoring.calculated_fields.enabled:true}")
    protected boolean checkCalculatedFields;

    public void init() {
        if (this.configs == null || this.configs.isEmpty()) {
            return;
        }
        this.configs.forEach(config -> config.getTargets().forEach(target -> {
            BaseHealthChecker<MonitoringConfig, MonitoringTarget> healthChecker = this.initHealthChecker(target, config);
            this.healthCheckers.add(healthChecker);
            if (target.isCheckDomainIps()) {
                this.getAssociatedUrls(target.getBaseUrl()).forEach(url -> healthChecker.getAssociates().put((String)url, this.initHealthChecker(this.createTarget((String)url), config)));
            }
        }));
    }

    private BaseHealthChecker<C, T> initHealthChecker(T target, C config) {
        BaseHealthChecker<?, ?> healthChecker = this.createHealthChecker(config, target);
        log.info("Initializing {} for {}", (Object)healthChecker.getClass().getSimpleName(), (Object)target.getBaseUrl());
        healthChecker.initialize();
        this.devices.add(target.getDeviceId());
        return healthChecker;
    }

    public final void runChecks() {
        if (this.healthCheckers.isEmpty()) {
            return;
        }
        try {
            log.info("Starting {}", (Object)this.getName());
            this.stopWatch.start();
            String accessToken = this.tbClient.logIn();
            this.reporter.reportLatency("logIn", this.stopWatch.getTime());
            try (WsClient wsClient = this.wsClientFactory.createClient(accessToken);){
                this.stopWatch.start();
                wsClient.subscribeForTelemetry(this.devices, this.getTestTelemetryKeys()).waitForReply();
                this.reporter.reportLatency("wsSubscribe", this.stopWatch.getTime());
                for (BaseHealthChecker<C, T> healthChecker : this.healthCheckers) {
                    this.check(healthChecker, wsClient);
                }
            }
            if (this.checkEdqs) {
                this.stopWatch.start();
                this.checkEdqs();
                this.reporter.reportLatency("edqsQuery", this.stopWatch.getTime());
                this.reporter.serviceIsOk("*EDQS*");
            }
            this.reporter.reportLatencies();
            log.debug("Finished {}", (Object)this.getName());
        }
        catch (ServiceFailureException e) {
            this.reporter.serviceFailure(e.getServiceKey(), e);
        }
        catch (Throwable error) {
            try {
                this.reporter.serviceFailure("Monitoring", error);
            }
            catch (Throwable reportError) {
                log.error("Error occurred during service failure reporting", reportError);
            }
        }
    }

    private void check(BaseHealthChecker<C, T> healthChecker, WsClient wsClient) throws Exception {
        healthChecker.check(wsClient);
        T target = healthChecker.getTarget();
        if (target.isCheckDomainIps()) {
            Set<String> associatedUrls = this.getAssociatedUrls(target.getBaseUrl());
            Map<String, BaseHealthChecker<C, T>> associates = healthChecker.getAssociates();
            HashSet<String> prevAssociatedUrls = new HashSet<String>(associates.keySet());
            boolean changed = false;
            for (String url : associatedUrls) {
                if (prevAssociatedUrls.contains(url)) continue;
                BaseHealthChecker<C, T> associate = this.initHealthChecker(this.createTarget(url), healthChecker.getConfig());
                associates.put(url, associate);
                changed = true;
            }
            for (String url : prevAssociatedUrls) {
                if (associatedUrls.contains(url)) continue;
                this.stopHealthChecker(healthChecker);
                associates.remove(url);
                changed = true;
            }
            if (changed) {
                log.info("Updated IPs for {}: {} (old list: {})", new Object[]{target.getBaseUrl(), associatedUrls, prevAssociatedUrls});
            }
        }
    }

    private void checkEdqs() {
        EntityTypeFilter entityTypeFilter = new EntityTypeFilter();
        entityTypeFilter.setEntityType(EntityType.DEVICE);
        EntityDataPageLink pageLink = new EntityDataPageLink(100, 0, null, new EntityDataSortOrder(new EntityKey(EntityKeyType.ENTITY_FIELD, "name")));
        EntityDataQuery entityDataQuery = new EntityDataQuery((EntityFilter)entityTypeFilter, pageLink, List.of(new EntityKey(EntityKeyType.ENTITY_FIELD, "name"), new EntityKey(EntityKeyType.ENTITY_FIELD, "type")), List.of(new EntityKey(EntityKeyType.TIME_SERIES, "testData")), Collections.emptyList());
        PageData result = this.tbClient.findEntityDataByQuery(entityDataQuery);
        Set devices = result.getData().stream().map(entityData -> entityData.getEntityId().getId()).collect(Collectors.toSet());
        Sets.SetView missing = Sets.difference(new HashSet<UUID>(this.devices), devices);
        if (!missing.isEmpty()) {
            throw new ServiceFailureException((Object)"*EDQS*", "Missing devices in the response: " + String.valueOf(missing));
        }
        result.getData().stream().filter(entityData -> this.devices.contains(entityData.getEntityId().getId())).forEach(entityData -> {
            HashMap values = new HashMap((Map)entityData.getLatest().get(EntityKeyType.ENTITY_FIELD));
            values.putAll((Map)entityData.getLatest().get(EntityKeyType.TIME_SERIES));
            Stream.of("name", "type", "testData").forEach(key -> {
                TsValue value = (TsValue)values.get(key);
                if (value == null || StringUtils.isBlank((CharSequence)value.getValue())) {
                    throw new ServiceFailureException((Object)"*EDQS*", "Missing " + key + " for device " + String.valueOf(entityData.getEntityId()));
                }
            });
        });
    }

    private Set<String> getAssociatedUrls(String baseUrl) {
        URI url = new URI(baseUrl);
        return Arrays.stream(InetAddress.getAllByName(url.getHost())).map(InetAddress::getHostAddress).map(ip -> {
            try {
                return new URI(url.getScheme(), null, (String)ip, url.getPort(), "", null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    private List<String> getTestTelemetryKeys() {
        return this.checkCalculatedFields ? List.of("testData", "testDataCf") : List.of("testData");
    }

    private void stopHealthChecker(BaseHealthChecker<C, T> healthChecker) throws Exception {
        healthChecker.destroyClient();
        this.devices.remove(healthChecker.getTarget().getDeviceId());
        log.info("Stopped {} for {}", (Object)healthChecker.getClass().getSimpleName(), (Object)healthChecker.getTarget().getBaseUrl());
    }

    protected abstract BaseHealthChecker<?, ?> createHealthChecker(C var1, T var2);

    protected abstract T createTarget(String var1);

    protected abstract String getName();
}

