/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.notification;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.monitoring.data.notification.Notification;
import org.thingsboard.monitoring.notification.channels.NotificationChannel;

@Component
public class NotificationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotificationService.class);
    private final List<NotificationChannel> notificationChannels;
    private final ExecutorService notificationExecutor = Executors.newSingleThreadExecutor();
    @Value(value="${monitoring.notifications.message_prefix}")
    private String messagePrefix;

    public void sendNotification(Notification notification) {
        Object message = StringUtils.isEmpty((CharSequence)this.messagePrefix) ? notification.getText() : this.messagePrefix + System.lineSeparator() + notification.getText();
        this.notificationChannels.forEach(arg_0 -> this.lambda$sendNotification$1((String)message, arg_0));
    }

    @ConstructorProperties(value={"notificationChannels"})
    @Generated
    public NotificationService(List<NotificationChannel> notificationChannels) {
        this.notificationChannels = notificationChannels;
    }

    private /* synthetic */ void lambda$sendNotification$1(String message, NotificationChannel notificationChannel) {
        this.notificationExecutor.submit(() -> {
            try {
                notificationChannel.sendNotification(message);
            }
            catch (Exception e) {
                log.error("Failed to send notification to {}", (Object)notificationChannel.getClass().getSimpleName(), (Object)e);
            }
        });
    }
}

