/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.transport.impl;

import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.monitoring.config.transport.HttpTransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringTarget;
import org.thingsboard.monitoring.config.transport.TransportType;
import org.thingsboard.monitoring.service.transport.TransportHealthChecker;

@Component
@Scope(value="prototype")
public class HttpTransportHealthChecker
extends TransportHealthChecker<HttpTransportMonitoringConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpTransportHealthChecker.class);
    private RestTemplate restTemplate;

    protected HttpTransportHealthChecker(HttpTransportMonitoringConfig config, TransportMonitoringTarget target) {
        super((TransportMonitoringConfig)config, target);
    }

    protected void initClient() throws Exception {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(Duration.ofMillis(((HttpTransportMonitoringConfig)this.config).getRequestTimeoutMs())).setReadTimeout(Duration.ofMillis(((HttpTransportMonitoringConfig)this.config).getRequestTimeoutMs())).build();
            log.debug("Initialized HTTP client");
        }
    }

    protected void sendTestPayload(String payload) throws Exception {
        String accessToken = ((TransportMonitoringTarget)this.target).getDevice().getCredentials().getCredentialsId();
        this.restTemplate.postForObject(((TransportMonitoringTarget)this.target).getBaseUrl() + "/api/v1/" + accessToken + "/telemetry", (Object)payload, String.class, new Object[0]);
    }

    protected void destroyClient() throws Exception {
    }

    protected TransportType getTransportType() {
        return TransportType.HTTP;
    }
}

