/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.transport.impl;

import java.io.IOException;
import lombok.Generated;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.elements.config.SystemConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.thingsboard.monitoring.config.transport.CoapTransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringTarget;
import org.thingsboard.monitoring.config.transport.TransportType;
import org.thingsboard.monitoring.service.transport.TransportHealthChecker;

@Component
@Scope(value="prototype")
public class CoapTransportHealthChecker
extends TransportHealthChecker<CoapTransportMonitoringConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CoapTransportHealthChecker.class);
    private CoapClient coapClient;

    protected CoapTransportHealthChecker(CoapTransportMonitoringConfig config, TransportMonitoringTarget target) {
        super((TransportMonitoringConfig)config, target);
    }

    protected void initClient() throws Exception {
        if (this.coapClient == null) {
            String accessToken = ((TransportMonitoringTarget)this.target).getDevice().getCredentials().getCredentialsId();
            String uri = ((TransportMonitoringTarget)this.target).getBaseUrl() + "/api/v1/" + accessToken + "/telemetry";
            this.coapClient = new CoapClient(uri);
            this.coapClient.setTimeout(Long.valueOf(((CoapTransportMonitoringConfig)this.config).getRequestTimeoutMs()));
            log.debug("Initialized CoAP client for URI {}", (Object)uri);
        }
    }

    protected void sendTestPayload(String payload) throws Exception {
        CoapResponse response = this.coapClient.post(payload, 50);
        CoAP.ResponseCode code = response.getCode();
        if (code.codeClass != CoAP.CodeClass.SUCCESS_RESPONSE.value) {
            throw new IOException("COAP client didn't receive success response from transport");
        }
    }

    protected void destroyClient() throws Exception {
        if (this.coapClient != null) {
            this.coapClient.shutdown();
            this.coapClient = null;
            log.info("Disconnected CoAP client");
        }
    }

    protected TransportType getTransportType() {
        return TransportType.COAP;
    }

    static {
        SystemConfig.register();
    }
}

