/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.integration.impl;

import lombok.Generated;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.thingsboard.monitoring.config.integration.IntegrationMonitoringConfig;
import org.thingsboard.monitoring.config.integration.IntegrationMonitoringTarget;
import org.thingsboard.monitoring.config.integration.IntegrationType;
import org.thingsboard.monitoring.config.integration.MqttIntegrationMonitoringConfig;
import org.thingsboard.monitoring.service.integration.IntegrationHealthChecker;

@Service
@Scope(value="prototype")
public class MqttIntegrationHealthChecker
extends IntegrationHealthChecker<MqttIntegrationMonitoringConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttIntegrationHealthChecker.class);
    private MqttClient mqttClient;
    private String topic;

    public MqttIntegrationHealthChecker(MqttIntegrationMonitoringConfig config, IntegrationMonitoringTarget target) {
        super((IntegrationMonitoringConfig)config, target);
    }

    protected void initClient() throws Exception {
        if (this.mqttClient == null || !this.mqttClient.isConnected()) {
            String clientId = this.domain + "-integration-monitoring-" + MqttAsyncClient.generateClientId();
            String userName = ((IntegrationMonitoringTarget)this.target).getIntegration().getConfiguration().get("clientConfiguration").get("credentials").get("username").asText();
            this.mqttClient = new MqttClient(((IntegrationMonitoringTarget)this.target).getBaseUrl(), clientId, (MqttClientPersistence)new MemoryPersistence());
            this.mqttClient.setTimeToWait((long)((MqttIntegrationMonitoringConfig)this.config).getRequestTimeoutMs());
            this.topic = "monitoring/" + ((IntegrationMonitoringTarget)this.target).getIntegration().getRoutingKey();
            MqttConnectOptions options = new MqttConnectOptions();
            options.setUserName(userName);
            options.setConnectionTimeout(((MqttIntegrationMonitoringConfig)this.config).getRequestTimeoutMs() / 1000);
            IMqttToken result = this.mqttClient.connectWithResult(options);
            if (result.getException() != null) {
                throw result.getException();
            }
            log.debug("Initialized MQTT client for URI {}", (Object)this.mqttClient.getServerURI());
        }
    }

    protected void sendTestPayload(String payload) throws Exception {
        MqttMessage message = new MqttMessage();
        message.setPayload(payload.getBytes());
        message.setQos(1);
        this.mqttClient.publish(this.topic, message);
    }

    protected void destroyClient() throws Exception {
        if (this.mqttClient != null) {
            this.mqttClient.disconnect();
            this.mqttClient = null;
            log.info("Disconnected MQTT client");
        }
    }

    protected IntegrationType getIntegrationType() {
        return IntegrationType.MQTT;
    }
}

