/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.integration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.monitoring.config.MonitoringTarget;
import org.thingsboard.monitoring.config.integration.IntegrationInfo;
import org.thingsboard.monitoring.config.integration.IntegrationMonitoringConfig;
import org.thingsboard.monitoring.config.integration.IntegrationMonitoringTarget;
import org.thingsboard.monitoring.config.integration.IntegrationType;
import org.thingsboard.monitoring.service.BaseHealthChecker;

public abstract class IntegrationHealthChecker<C extends IntegrationMonitoringConfig>
extends BaseHealthChecker<C, IntegrationMonitoringTarget> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationHealthChecker.class);

    public IntegrationHealthChecker(C config, IntegrationMonitoringTarget target) {
        super(config, (MonitoringTarget)target);
    }

    protected final void initialize() {
        this.entityService.checkEntities((IntegrationMonitoringConfig)this.config, (IntegrationMonitoringTarget)this.target);
    }

    protected final String createTestPayload(String testValue) {
        ObjectNode payload = JacksonUtil.newObjectNode();
        payload.set("telemetry", JacksonUtil.newObjectNode().set("testData", (JsonNode)new TextNode(testValue)));
        payload.set("device", (JsonNode)new TextNode(((IntegrationMonitoringTarget)this.target).getDevice().getName()));
        return payload.toString();
    }

    protected final Object getInfo() {
        return new IntegrationInfo(this.getIntegrationType(), ((IntegrationMonitoringTarget)this.target).getBaseUrl());
    }

    protected final String getKey() {
        return this.getIntegrationType().name().toLowerCase() + "Integration";
    }

    protected abstract IntegrationType getIntegrationType();

    protected boolean isCfMonitoringEnabled() {
        return false;
    }
}

