/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.notification.channels.impl;

import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.thingsboard.monitoring.notification.channels.NotificationChannel;

@Component
@ConditionalOnProperty(value={"monitoring.notifications.slack.enabled"}, havingValue="true")
public class SlackNotificationChannel
implements NotificationChannel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackNotificationChannel.class);
    @Value(value="${monitoring.notifications.slack.webhook_url}")
    private String webhookUrl;
    private RestTemplate restTemplate;

    @PostConstruct
    private void init() {
        this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setConnectTimeout(Duration.ofSeconds(5L)).setReadTimeout(Duration.ofSeconds(2L)).build();
    }

    public void sendNotification(String message) {
        this.restTemplate.postForObject(this.webhookUrl, Map.of("text", message), String.class, new Object[0]);
    }
}

