/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.transport.impl;

import lombok.Generated;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.thingsboard.monitoring.config.transport.MqttTransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringTarget;
import org.thingsboard.monitoring.config.transport.TransportType;
import org.thingsboard.monitoring.service.transport.TransportHealthChecker;

@Component
@Scope(value="prototype")
public class MqttTransportHealthChecker
extends TransportHealthChecker<MqttTransportMonitoringConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MqttTransportHealthChecker.class);
    private MqttClient mqttClient;
    private static final String DEVICE_TELEMETRY_TOPIC = "v1/devices/me/telemetry";

    protected MqttTransportHealthChecker(MqttTransportMonitoringConfig config, TransportMonitoringTarget target) {
        super(config, target);
    }

    @Override
    protected void initClient() throws Exception {
        if (this.mqttClient == null || !this.mqttClient.isConnected()) {
            String clientId = MqttAsyncClient.generateClientId();
            String accessToken = ((TransportMonitoringTarget)this.target).getDevice().getCredentials().getCredentialsId();
            this.mqttClient = new MqttClient(((TransportMonitoringTarget)this.target).getBaseUrl(), clientId, (MqttClientPersistence)new MemoryPersistence());
            this.mqttClient.setTimeToWait((long)((MqttTransportMonitoringConfig)this.config).getRequestTimeoutMs());
            MqttConnectOptions options = new MqttConnectOptions();
            options.setUserName(accessToken);
            options.setConnectionTimeout(((MqttTransportMonitoringConfig)this.config).getRequestTimeoutMs() / 1000);
            IMqttToken result = this.mqttClient.connectWithResult(options);
            if (result.getException() != null) {
                throw result.getException();
            }
            log.debug("Initialized MQTT client for URI {}", (Object)this.mqttClient.getServerURI());
        }
    }

    @Override
    protected void sendTestPayload(String payload) throws Exception {
        MqttMessage message = new MqttMessage();
        message.setPayload(payload.getBytes());
        message.setQos(((MqttTransportMonitoringConfig)this.config).getQos().intValue());
        this.mqttClient.publish(DEVICE_TELEMETRY_TOPIC, message);
    }

    @Override
    protected void destroyClient() throws Exception {
        if (this.mqttClient != null) {
            this.mqttClient.disconnect();
            this.mqttClient = null;
            log.info("Disconnected MQTT client");
        }
    }

    @Override
    protected TransportType getTransportType() {
        return TransportType.MQTT;
    }
}

