/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service.transport;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.monitoring.config.transport.TransportInfo;
import org.thingsboard.monitoring.config.transport.TransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringTarget;
import org.thingsboard.monitoring.config.transport.TransportType;
import org.thingsboard.monitoring.service.BaseHealthChecker;

public abstract class TransportHealthChecker<C extends TransportMonitoringConfig>
extends BaseHealthChecker<C, TransportMonitoringTarget> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransportHealthChecker.class);
    @Value(value="${monitoring.calculated_fields.enabled:true}")
    private boolean calculatedFieldsMonitoringEnabled;

    public TransportHealthChecker(C config, TransportMonitoringTarget target) {
        super(config, target);
    }

    @Override
    protected void initialize() {
        this.entityService.checkEntities((TransportMonitoringConfig)this.config, (TransportMonitoringTarget)this.target);
    }

    @Override
    protected String createTestPayload(String testValue) {
        return JacksonUtil.newObjectNode().set("testData", (JsonNode)new TextNode(testValue)).toString();
    }

    @Override
    protected Object getInfo() {
        return new TransportInfo(this.getTransportType(), (TransportMonitoringTarget)this.target);
    }

    @Override
    protected String getKey() {
        return this.getTransportType().name().toLowerCase() + (((TransportMonitoringTarget)this.target).getQueue().equals("Main") ? "" : ((TransportMonitoringTarget)this.target).getQueue()) + "Transport";
    }

    protected abstract TransportType getTransportType();

    @Override
    protected boolean isCfMonitoringEnabled() {
        return this.calculatedFieldsMonitoringEnabled;
    }
}

