/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.common.util.RegexUtils;
import org.thingsboard.monitoring.client.TbClient;
import org.thingsboard.monitoring.config.transport.DeviceConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringConfig;
import org.thingsboard.monitoring.config.transport.TransportMonitoringTarget;
import org.thingsboard.monitoring.config.transport.TransportType;
import org.thingsboard.monitoring.util.ResourceUtils;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.TbResource;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.cf.CalculatedField;
import org.thingsboard.server.common.data.cf.CalculatedFieldType;
import org.thingsboard.server.common.data.cf.configuration.Argument;
import org.thingsboard.server.common.data.cf.configuration.ArgumentType;
import org.thingsboard.server.common.data.cf.configuration.CalculatedFieldConfiguration;
import org.thingsboard.server.common.data.cf.configuration.Output;
import org.thingsboard.server.common.data.cf.configuration.OutputType;
import org.thingsboard.server.common.data.cf.configuration.ReferencedEntityKey;
import org.thingsboard.server.common.data.cf.configuration.ScriptCalculatedFieldConfiguration;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MBootstrapClientCredential;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MBootstrapClientCredentials;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MClientCredential;
import org.thingsboard.server.common.data.device.credentials.lwm2m.LwM2MDeviceCredentials;
import org.thingsboard.server.common.data.device.credentials.lwm2m.NoSecBootstrapClientCredential;
import org.thingsboard.server.common.data.device.credentials.lwm2m.NoSecClientCredential;
import org.thingsboard.server.common.data.device.data.DefaultDeviceConfiguration;
import org.thingsboard.server.common.data.device.data.DefaultDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.data.DeviceConfiguration;
import org.thingsboard.server.common.data.device.data.DeviceData;
import org.thingsboard.server.common.data.device.data.DeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.data.Lwm2mDeviceTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.DefaultDeviceProfileConfiguration;
import org.thingsboard.server.common.data.device.profile.DefaultDeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileConfiguration;
import org.thingsboard.server.common.data.device.profile.DeviceProfileData;
import org.thingsboard.server.common.data.device.profile.DeviceProfileTransportConfiguration;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleChainMetaData;
import org.thingsboard.server.common.data.rule.RuleChainType;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;

@Service
public class MonitoringEntityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MonitoringEntityService.class);
    private final TbClient tbClient;
    @Value(value="${monitoring.calculated_fields.enabled:true}")
    private boolean calculatedFieldsMonitoringEnabled;

    public void checkEntities() {
        int newVersion;
        RuleChain ruleChain = this.tbClient.getRuleChains(RuleChainType.CORE, new PageLink(10)).getData().stream().filter(RuleChain::isRoot).findFirst().orElseThrow();
        RuleChainId ruleChainId = ruleChain.getId();
        JsonNode ruleChainDescriptor = ResourceUtils.getResource("rule_chain.json");
        List attributeKeys = this.tbClient.getAttributeKeys((EntityId)ruleChainId);
        Map<String, String> attributes = this.tbClient.getAttributeKvEntries((EntityId)ruleChainId, attributeKeys).stream().collect(Collectors.toMap(KvEntry::getKey, KvEntry::getValueAsString));
        int currentVersion = Integer.parseInt(attributes.getOrDefault("version", "0"));
        if (currentVersion == (newVersion = ruleChainDescriptor.get("version").asInt())) {
            log.info("Not updating rule chain, version is the same ({})", (Object)currentVersion);
            return;
        }
        log.info("Updating rule chain '{}' from version {} to {}", new Object[]{ruleChain.getName(), currentVersion, newVersion});
        String metadataJson = RegexUtils.replace((String)ruleChainDescriptor.get("metadata").toString(), (String)"\\$\\{MONITORING:(.+?)}", matchResult -> {
            String key = matchResult.group(1);
            String value = (String)attributes.get(key);
            if (value == null) {
                throw new IllegalArgumentException("No attribute found for key " + key);
            }
            log.info("Using {}: {}", (Object)key, (Object)value);
            return value;
        });
        RuleChainMetaData metaData = (RuleChainMetaData)JacksonUtil.fromString((String)metadataJson, RuleChainMetaData.class);
        metaData.setRuleChainId(ruleChainId);
        this.tbClient.saveRuleChainMetaData(metaData);
        this.tbClient.saveEntityAttributesV2((EntityId)ruleChainId, "SERVER_SCOPE", (JsonNode)JacksonUtil.newObjectNode().put("version", newVersion));
    }

    public Asset getOrCreateMonitoringAsset() {
        String assetName = "[Monitoring] Latencies";
        return this.tbClient.findAsset(assetName).orElseGet(() -> {
            Asset asset = new Asset();
            asset.setType("Monitoring");
            asset.setName(assetName);
            asset = this.tbClient.saveAsset(asset);
            log.info("Created monitoring asset {}", (Object)asset.getId());
            return asset;
        });
    }

    public void checkEntities(TransportMonitoringConfig config, TransportMonitoringTarget target) {
        Device device = this.getOrCreateDevice(config, target);
        DeviceCredentials credentials = (DeviceCredentials)this.tbClient.getDeviceCredentialsByDeviceId(device.getId()).orElseThrow(() -> new IllegalArgumentException("No credentials found for device " + String.valueOf(device.getId())));
        DeviceConfig deviceConfig = new DeviceConfig();
        deviceConfig.setId(device.getId().toString());
        deviceConfig.setName(device.getName());
        deviceConfig.setCredentials(credentials);
        target.setDevice(deviceConfig);
    }

    private Device getOrCreateDevice(TransportMonitoringConfig config, TransportMonitoringTarget target) {
        TransportType transportType = config.getTransportType();
        String deviceName = String.format("%s %s (%s) - %s", target.getNamePrefix(), transportType.getName(), target.getQueue(), target.getBaseUrl()).trim();
        Device device = this.tbClient.getTenantDevice(deviceName).orElse(null);
        if (device != null) {
            CalculatedField calculatedField;
            if (this.calculatedFieldsMonitoringEnabled && (calculatedField = (CalculatedField)this.tbClient.getCalculatedFieldsByEntityId((EntityId)device.getId(), new PageLink(1, 0, "testDataCf")).getData().stream().findFirst().orElse(null)) == null) {
                this.createCalculatedField(device);
            }
            return device;
        }
        log.info("Creating new device '{}'", (Object)deviceName);
        device = new Device();
        device.setName(deviceName);
        DeviceCredentials credentials = new DeviceCredentials();
        credentials.setCredentialsId(RandomStringUtils.randomAlphabetic((int)20));
        DeviceData deviceData = new DeviceData();
        deviceData.setConfiguration((DeviceConfiguration)new DefaultDeviceConfiguration());
        DeviceProfile deviceProfile = this.getOrCreateDeviceProfile(config, target);
        device.setType(deviceProfile.getName());
        device.setDeviceProfileId(deviceProfile.getId());
        if (transportType != TransportType.LWM2M) {
            deviceData.setTransportConfiguration((DeviceTransportConfiguration)new DefaultDeviceTransportConfiguration());
            credentials.setCredentialsType(DeviceCredentialsType.ACCESS_TOKEN);
        } else {
            deviceData.setTransportConfiguration((DeviceTransportConfiguration)new Lwm2mDeviceTransportConfiguration());
            credentials.setCredentialsType(DeviceCredentialsType.LWM2M_CREDENTIALS);
            LwM2MDeviceCredentials lwm2mCreds = new LwM2MDeviceCredentials();
            NoSecClientCredential client = new NoSecClientCredential();
            client.setEndpoint(credentials.getCredentialsId());
            lwm2mCreds.setClient((LwM2MClientCredential)client);
            LwM2MBootstrapClientCredentials bootstrap = new LwM2MBootstrapClientCredentials();
            bootstrap.setBootstrapServer((LwM2MBootstrapClientCredential)new NoSecBootstrapClientCredential());
            bootstrap.setLwm2mServer((LwM2MBootstrapClientCredential)new NoSecBootstrapClientCredential());
            lwm2mCreds.setBootstrap(bootstrap);
            credentials.setCredentialsValue(JacksonUtil.toString((Object)lwm2mCreds));
        }
        device = (Device)this.tbClient.saveDeviceWithCredentials(device, credentials).get();
        if (this.calculatedFieldsMonitoringEnabled) {
            this.createCalculatedField(device);
        }
        return device;
    }

    private DeviceProfile getOrCreateDeviceProfile(TransportMonitoringConfig config, TransportMonitoringTarget target) {
        TransportType transportType = config.getTransportType();
        String profileName = String.format("%s %s (%s)", target.getNamePrefix(), transportType.getName(), target.getQueue()).trim();
        DeviceProfile deviceProfile = this.tbClient.getDeviceProfiles(new PageLink(1, 0, profileName)).getData().stream().findFirst().orElse(null);
        if (deviceProfile != null) {
            return deviceProfile;
        }
        log.info("Creating new device profile '{}'", (Object)profileName);
        if (transportType != TransportType.LWM2M) {
            deviceProfile = new DeviceProfile();
            deviceProfile.setType(DeviceProfileType.DEFAULT);
            deviceProfile.setTransportType(DeviceTransportType.DEFAULT);
            DeviceProfileData profileData = new DeviceProfileData();
            profileData.setConfiguration((DeviceProfileConfiguration)new DefaultDeviceProfileConfiguration());
            profileData.setTransportConfiguration((DeviceProfileTransportConfiguration)new DefaultDeviceProfileTransportConfiguration());
            deviceProfile.setProfileData(profileData);
        } else {
            this.tbClient.getResources(new PageLink(1, 0, "LwM2M Monitoring")).getData().stream().findFirst().orElseGet(() -> {
                TbResource newResource = ResourceUtils.getResource("lwm2m/resource.json", TbResource.class);
                log.info("Creating LwM2M resource");
                return this.tbClient.saveResource(newResource);
            });
            deviceProfile = ResourceUtils.getResource("lwm2m/device_profile.json", DeviceProfile.class);
        }
        deviceProfile.setName(profileName);
        deviceProfile.setDefaultQueueName(target.getQueue());
        return this.tbClient.saveDeviceProfile(deviceProfile);
    }

    private void createCalculatedField(Device device) {
        log.info("Creating calculated field for device '{}'", (Object)device.getName());
        CalculatedField calculatedField = new CalculatedField();
        calculatedField.setName("testDataCf");
        calculatedField.setEntityId((EntityId)device.getId());
        calculatedField.setType(CalculatedFieldType.SCRIPT);
        ScriptCalculatedFieldConfiguration configuration = new ScriptCalculatedFieldConfiguration();
        Argument testDataArgument = new Argument();
        testDataArgument.setRefEntityKey(new ReferencedEntityKey("testData", ArgumentType.TS_LATEST, null));
        configuration.setArguments(Map.of("testData", testDataArgument));
        configuration.setExpression("return { \"testDataCf\": testData + \"-cf\" };");
        Output output = new Output();
        output.setType(OutputType.TIME_SERIES);
        configuration.setOutput(output);
        calculatedField.setConfiguration((CalculatedFieldConfiguration)configuration);
        calculatedField.setDebugMode(true);
        this.tbClient.saveCalculatedField(calculatedField);
    }

    @ConstructorProperties(value={"tbClient"})
    @Generated
    public MonitoringEntityService(TbClient tbClient) {
        this.tbClient = tbClient;
    }
}

