/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.service;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.monitoring.client.WsClient;
import org.thingsboard.monitoring.config.MonitoringConfig;
import org.thingsboard.monitoring.config.MonitoringTarget;
import org.thingsboard.monitoring.data.Latencies;
import org.thingsboard.monitoring.data.ServiceFailureException;
import org.thingsboard.monitoring.service.MonitoringEntityService;
import org.thingsboard.monitoring.service.MonitoringReporter;
import org.thingsboard.monitoring.util.TbStopWatch;

public abstract class BaseHealthChecker<C extends MonitoringConfig, T extends MonitoringTarget> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseHealthChecker.class);
    protected final C config;
    protected final T target;
    private Object info;
    @Autowired
    protected MonitoringEntityService entityService;
    @Autowired
    private MonitoringReporter reporter;
    @Autowired
    private TbStopWatch stopWatch;
    @Value(value="${monitoring.check_timeout_ms}")
    private int resultCheckTimeoutMs;
    private final Map<String, BaseHealthChecker<C, T>> associates = new HashMap<String, BaseHealthChecker<C, T>>();
    public static final String TEST_TELEMETRY_KEY = "testData";
    public static final String TEST_CF_TELEMETRY_KEY = "testDataCf";

    @PostConstruct
    private void init() {
        this.info = this.getInfo();
    }

    protected abstract void initialize();

    public final void check(WsClient wsClient) {
        log.debug("[{}] Checking", this.info);
        try {
            int expectedUpdatesCount = this.isCfMonitoringEnabled() ? 2 : 1;
            wsClient.registerWaitForUpdates(expectedUpdatesCount);
            String testValue = UUID.randomUUID().toString();
            String testPayload = this.createTestPayload(testValue);
            try {
                this.initClient();
                this.stopWatch.start();
                this.sendTestPayload(testPayload);
                this.reporter.reportLatency(Latencies.request(this.getKey()), this.stopWatch.getTime());
                log.trace("[{}] Sent test payload ({})", this.info, (Object)testPayload);
            }
            catch (Throwable e) {
                throw new ServiceFailureException(this.info, e);
            }
            log.trace("[{}] Waiting for WS update", this.info);
            this.checkWsUpdates(wsClient, testValue);
            this.reporter.serviceIsOk(this.info);
            this.reporter.serviceIsOk("Monitoring");
        }
        catch (ServiceFailureException e) {
            this.reporter.serviceFailure(e.getServiceKey(), e);
        }
        catch (Exception e) {
            this.reporter.serviceFailure("Monitoring", e);
        }
        this.associates.values().forEach(healthChecker -> healthChecker.check(wsClient));
    }

    private void checkWsUpdates(WsClient wsClient, String testValue) {
        this.stopWatch.start();
        wsClient.waitForUpdates(this.resultCheckTimeoutMs);
        log.trace("[{}] Waited for WS update. Last WS msgs: {}", this.info, wsClient.lastMsgs);
        Map<String, String> latest = wsClient.getLatest(this.target.getDeviceId());
        if (latest.isEmpty()) {
            throw new ServiceFailureException(this.info, "No WS update arrived within " + this.resultCheckTimeoutMs + " ms");
        }
        String actualValue = latest.get(TEST_TELEMETRY_KEY);
        if (!testValue.equals(actualValue)) {
            throw new ServiceFailureException(this.info, "Was expecting value " + testValue + " but got " + actualValue);
        }
        if (this.isCfMonitoringEnabled()) {
            String cfTestValue = testValue + "-cf";
            String actualCfValue = latest.get(TEST_CF_TELEMETRY_KEY);
            if (actualCfValue == null) {
                throw new ServiceFailureException(this.info, "No calculated field value arrived");
            }
            if (!cfTestValue.equals(actualCfValue)) {
                throw new ServiceFailureException(this.info, "Was expecting calculated field value " + cfTestValue + " but got " + actualCfValue);
            }
        }
        this.reporter.reportLatency(Latencies.wsUpdate(this.getKey()), this.stopWatch.getTime());
    }

    protected abstract void initClient() throws Exception;

    protected abstract String createTestPayload(String var1);

    protected abstract void sendTestPayload(String var1) throws Exception;

    @PreDestroy
    protected abstract void destroyClient() throws Exception;

    protected abstract Object getInfo();

    protected abstract String getKey();

    protected abstract boolean isCfMonitoringEnabled();

    @ConstructorProperties(value={"config", "target"})
    @Generated
    public BaseHealthChecker(C config, T target) {
        this.config = config;
        this.target = target;
    }

    @Generated
    public C getConfig() {
        return this.config;
    }

    @Generated
    public T getTarget() {
        return this.target;
    }

    @Generated
    public Map<String, BaseHealthChecker<C, T>> getAssociates() {
        return this.associates;
    }
}

