/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.data.notification;

import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.thingsboard.monitoring.data.notification.Notification;

public class ServiceFailureNotification
implements Notification {
    private final Object serviceKey;
    private final Throwable error;
    private final int failuresCount;

    public ServiceFailureNotification(Object serviceKey, Throwable error, int failuresCount) {
        this.serviceKey = serviceKey;
        this.error = error;
        this.failuresCount = failuresCount;
    }

    @Override
    public String getText() {
        Throwable cause;
        String errorMsg = this.error.getMessage();
        if ((errorMsg == null || errorMsg.equals("null")) && (cause = ExceptionUtils.getRootCause((Throwable)this.error)) != null) {
            errorMsg = cause.getMessage();
        }
        if (errorMsg == null) {
            errorMsg = this.error.getClass().getSimpleName();
        }
        return String.format("%s - Failure: %s (number of subsequent failures: %s)", this.serviceKey, errorMsg, this.failuresCount);
    }

    @Generated
    public Object getServiceKey() {
        return this.serviceKey;
    }

    @Generated
    public Throwable getError() {
        return this.error;
    }

    @Generated
    public int getFailuresCount() {
        return this.failuresCount;
    }
}

