/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.monitoring.client;

import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.thingsboard.monitoring.client.WsClient;
import org.thingsboard.monitoring.service.MonitoringReporter;
import org.thingsboard.monitoring.util.TbStopWatch;

@Component
public class WsClientFactory {
    private final MonitoringReporter monitoringReporter;
    private final TbStopWatch stopWatch;
    @Value(value="${monitoring.ws.base_url}")
    private String baseUrl;
    @Value(value="${monitoring.ws.request_timeout_ms}")
    private int requestTimeoutMs;

    public WsClient createClient(String accessToken) throws Exception {
        boolean connected;
        URI uri = new URI(this.baseUrl + "/api/ws/plugins/telemetry?token=" + accessToken);
        this.stopWatch.start();
        WsClient wsClient = new WsClient(uri, this.requestTimeoutMs);
        if (this.baseUrl.startsWith("wss")) {
            SSLContextBuilder builder = SSLContexts.custom();
            builder.loadTrustMaterial(null, (chain, authType) -> true);
            wsClient.setSocketFactory(builder.build().getSocketFactory());
        }
        if (!(connected = wsClient.connectBlocking(this.requestTimeoutMs, TimeUnit.MILLISECONDS))) {
            throw new IllegalStateException("Failed to establish WS session");
        }
        this.monitoringReporter.reportLatency("wsConnect", this.stopWatch.getTime());
        return wsClient;
    }

    @ConstructorProperties(value={"monitoringReporter", "stopWatch"})
    @Generated
    public WsClientFactory(MonitoringReporter monitoringReporter, TbStopWatch stopWatch) {
        this.monitoringReporter = monitoringReporter;
        this.stopWatch = stopWatch;
    }
}

