/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.tenant.importing;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.utils.CassandraService;
import org.thingsboard.migrator.utils.Storage;

@Service
@ConditionalOnExpression(value="'${mode}' == 'TENANT_DATA_IMPORT' and ${import.cassandra.enabled} == true")
@Order(value=2)
public class CassandraTsKvImporter
extends MigrationService {
    private final Storage storage;
    private final CassandraService cassandraService;
    private final Map<PartitionKey, Set<Long>> partitions = new WeakHashMap<PartitionKey, Set<Long>>();
    @Value(value="${import.cassandra.ttl}")
    private int tsKvTtlDays;

    @Override
    protected void start() throws Exception {
        this.storage.readAndProcess("ts_kv", row -> {
            try {
                this.saveTsKv((Map<String, Object>)row);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save row: " + String.valueOf(row), e);
            }
        });
    }

    private void saveTsKv(Map<String, Object> row) {
        Object dblV;
        Object longV;
        String entityType = (String)row.get("entity_type");
        UUID entityId = (UUID)row.get("entity_id");
        String key = (String)row.get("key");
        PartitionKey partitionKey = PartitionKey.of(entityType, entityId, key);
        Long partition = ((Number)row.get("partition")).longValue();
        row.put("partition", partition);
        long ttl = TimeUnit.DAYS.toSeconds(this.tsKvTtlDays);
        boolean newPartition = this.partitions.computeIfAbsent(partitionKey, k -> new HashSet()).add(partition);
        if (newPartition) {
            Object query = "INSERT INTO ts_kv_partitions_cf (entity_type, entity_id, key, partition) VALUES (?, ?, ?, ?)";
            if (ttl > 0L) {
                query = (String)query + " USING TTL " + ttl;
            }
            String finalQuery = query;
            this.executor.submit(() -> this.cassandraService.execute(finalQuery, entityType, entityId, key, partition));
        }
        if ((longV = row.get("long_v")) != null && !(longV instanceof Long)) {
            row.put("long_v", ((Number)longV).longValue());
        }
        if ((dblV = row.get("dbl_v")) != null && !(dblV instanceof Double)) {
            row.put("dbl_v", ((Number)dblV).doubleValue());
        }
        Number ts = (Number)row.get("ts");
        ts = ts.longValue();
        row.put("ts", ts);
        String columnsStmt = String.join((CharSequence)", ", row.keySet());
        String valuesStmt = StringUtils.removeEnd((String)"?,".repeat(row.size()), (String)",");
        Object query = String.format("INSERT INTO ts_kv_cf (%s) VALUES (%s)", columnsStmt, valuesStmt);
        if (ttl > 0L) {
            query = (String)query + " USING TTL " + ttl;
        }
        String finalQuery = query;
        this.executor.submit(() -> {
            this.cassandraService.execute(finalQuery, row.values().toArray());
            this.reportProcessed("ts_kv_cf", row);
        });
    }

    @Override
    protected void afterFinished() throws Exception {
        this.finishedProcessing("ts_kv_cf");
    }

    @ConstructorProperties(value={"storage", "cassandraService"})
    @Generated
    public CassandraTsKvImporter(Storage storage, CassandraService cassandraService) {
        this.storage = storage;
        this.cassandraService = cassandraService;
    }

    private static class PartitionKey {
        private final String entityType;
        private final UUID entityId;
        private final String key;

        @ConstructorProperties(value={"entityType", "entityId", "key"})
        @Generated
        private PartitionKey(String entityType, UUID entityId, String key) {
            this.entityType = entityType;
            this.entityId = entityId;
            this.key = key;
        }

        @Generated
        public static PartitionKey of(String entityType, UUID entityId, String key) {
            return new PartitionKey(entityType, entityId, key);
        }

        @Generated
        public String getEntityType() {
            return this.entityType;
        }

        @Generated
        public UUID getEntityId() {
            return this.entityId;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PartitionKey)) {
                return false;
            }
            PartitionKey other = (PartitionKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$entityType = this.getEntityType();
            String other$entityType = other.getEntityType();
            if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
                return false;
            }
            UUID this$entityId = this.getEntityId();
            UUID other$entityId = other.getEntityId();
            if (this$entityId == null ? other$entityId != null : !((Object)this$entityId).equals(other$entityId)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PartitionKey;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $entityType = this.getEntityType();
            result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
            UUID $entityId = this.getEntityId();
            result = result * 59 + ($entityId == null ? 43 : ((Object)$entityId).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CassandraTsKvImporter.PartitionKey(entityType=" + this.getEntityType() + ", entityId=" + String.valueOf(this.getEntityId()) + ", key=" + this.getKey() + ")";
        }
    }
}

