/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.tenant.exporting;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.Table;
import org.thingsboard.migrator.utils.PostgresService;
import org.thingsboard.migrator.utils.SqlPartitionService;

@Service
@ConditionalOnExpression(value="'${mode}' == 'TENANT_DATA_EXPORT' and ${export.postgres.enabled} == true")
@Order(value=1)
public class PostgresTenantDataExporter
extends MigrationService {
    private final JdbcTemplate jdbcTemplate;
    private final SqlPartitionService partitionService;
    private final PostgresService postgresService;
    @Value(value="${export.tenant_id}")
    private UUID exportedTenantId;
    @Value(value="${export.postgres.batch_size}")
    private int batchSize;
    @Value(value="${export.postgres.delay_between_queries}")
    private int delayBetweenQueries;
    @Value(value="${skipped_tables}")
    private Set<Table> skippedTables;
    private static final Set<Table> relatedTables = Set.of(Table.RELATION, Table.ATTRIBUTE, Table.LATEST_KV);
    private final Map<Table, Writer> writers = new HashMap<Table, Writer>();

    @Override
    protected void start() throws Exception {
        for (Table table : relatedTables) {
            if (this.skippedTables.contains((Object)table)) continue;
            this.storage.newFile(table.getName());
        }
        for (Table table : Table.values()) {
            if (this.skippedTables.contains((Object)table) || relatedTables.contains((Object)table)) continue;
            this.exportTableData(table, this.exportedTenantId);
            this.finishedProcessing(table.getName());
        }
        for (Table relatedTable : relatedTables) {
            this.finishedProcessing(relatedTable.getName());
        }
        for (Writer writer : this.writers.values()) {
            writer.close();
        }
    }

    private void exportTableData(Table table, UUID tenantId) throws IOException {
        this.storage.newFile(table.getName());
        Object query = table.getCustomSelect() != null ? table.getCustomSelect().apply(tenantId) : String.format("SELECT * FROM %s WHERE ", table.getName());
        if (table.getReference() == null) {
            query = (String)query + String.format("%s.%s = '%s'", table.getName(), table.getTenantIdColumn(), tenantId);
        } else {
            Pair<String, List<Table>> reference = table.getReference();
            String referencingColumn = (String)reference.getKey();
            List referencedTables = (List)reference.getValue();
            for (Table referencedTable : referencedTables) {
                if (referencedTable.getReference() == null) {
                    query = (String)query + String.format(" %s IN (SELECT %s.id FROM %s WHERE %s.%s = '%s') OR", referencingColumn, referencedTable.getName(), referencedTable.getName(), referencedTable.getName(), referencedTable.getTenantIdColumn(), tenantId);
                    continue;
                }
                Pair<String, List<Table>> anotherReference = referencedTable.getReference();
                String column = (String)anotherReference.getKey();
                List tables = (List)anotherReference.getValue();
                for (Table anotherReferencedTable : tables) {
                    query = (String)query + String.format(" %s IN (SELECT %s.id FROM %s INNER JOIN %s ON %s.%s = %s.id WHERE %s.%s = '%s') OR", referencingColumn, referencedTable.getName(), referencedTable.getName(), anotherReferencedTable.getName(), referencedTable.getName(), column, anotherReferencedTable.getName(), anotherReferencedTable.getName(), anotherReferencedTable.getTenantIdColumn(), tenantId);
                }
            }
            query = StringUtils.removeEnd((String)query, (String)"OR");
        }
        query = (String)query + " ORDER BY " + String.join((CharSequence)", ", table.getSortColumns());
        this.queryAndSave(table, (String)query);
    }

    private void queryAndSave(Table table, String query) {
        Writer writer = this.writers.computeIfAbsent(table, k -> this.storage.newWriter(table.getName()));
        Consumer<Map<String, Object>> processor = row -> {
            try {
                this.prepareRow(table, (Map<String, Object>)row);
                try {
                    this.storage.addToFile(writer, (Map<String, Object>)row);
                }
                catch (Throwable e) {
                    this.log.error("[{}] Failed to add row to file: {} (query {})", new Object[]{table.getName(), row, query, e});
                    throw e;
                }
                this.reportProcessed(table.getName(), row);
                for (Table relatedTable : relatedTables) {
                    if (this.skippedTables.contains((Object)relatedTable) || !((List)relatedTable.getReference().getValue()).contains((Object)table)) continue;
                    Object relatedQuery = relatedTable.getCustomSelect() == null ? String.format("SELECT %s.* FROM %s WHERE ", relatedTable.getName(), relatedTable.getName()) : relatedTable.getCustomSelect().apply(null);
                    relatedQuery = String.format(PostgresTenantDataExporter.insertAfter((String)relatedQuery, "SELECT", " '%s' as table_name, "), table.toString());
                    relatedQuery = (String)relatedQuery + String.format("%s = '%s'", relatedTable.getReference().getKey(), row.get("id"));
                    relatedQuery = (String)relatedQuery + " ORDER BY " + String.join((CharSequence)", ", relatedTable.getSortColumns());
                    this.queryAndSave(relatedTable, (String)relatedQuery);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        if (!table.isPartitioned()) {
            this.query(query, processor, new Object[0]);
        } else {
            this.partitionService.getPartitions(table).forEach((partitionStart, partitionEnd) -> {
                String tsFilter = String.format(" %s.%s >= %s AND %s.%s < %s AND ", table.getName(), table.getPartitionColumn(), partitionStart, table.getName(), table.getPartitionColumn(), partitionEnd);
                this.query(PostgresTenantDataExporter.insertAfter(query, "WHERE", tsFilter), processor, new Object[0]);
            });
        }
    }

    private void prepareRow(Table table, Map<String, Object> row) {
        Long dataOid;
        if (table == Table.OTA_PACKAGE && (dataOid = (Long)row.get("data")) != null) {
            row.put("data", this.postgresService.getBlob(dataOid));
        }
    }

    private void query(String query, Consumer<Map<String, Object>> rowProcessor, Object ... queryParams) {
        int batchIndex = 0;
        boolean hasNextBatch = true;
        while (hasNextBatch) {
            int offset = batchIndex * this.batchSize;
            String batchQuery = query + " LIMIT " + this.batchSize + " OFFSET " + offset;
            List rows = this.jdbcTemplate.queryForList(batchQuery, queryParams);
            rows.forEach(rowProcessor);
            ++batchIndex;
            if (rows.size() < this.batchSize) {
                hasNextBatch = false;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(this.delayBetweenQueries);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String insertAfter(String input, String searchSequence, String value) {
        int afterSeq = StringUtils.indexOf((CharSequence)input, (CharSequence)searchSequence) + searchSequence.length();
        return input.substring(0, afterSeq) + value + input.substring(afterSeq);
    }

    @ConstructorProperties(value={"jdbcTemplate", "partitionService", "postgresService"})
    @Generated
    public PostgresTenantDataExporter(JdbcTemplate jdbcTemplate, SqlPartitionService partitionService, PostgresService postgresService) {
        this.jdbcTemplate = jdbcTemplate;
        this.partitionService = partitionService;
        this.postgresService = postgresService;
    }
}

