/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.tenant.exporting;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.beans.ConstructorProperties;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.Table;
import org.thingsboard.migrator.utils.CassandraService;
import org.thingsboard.migrator.utils.Storage;

@Service
@ConditionalOnExpression(value="'${mode}' == 'TENANT_DATA_EXPORT' and ${export.cassandra.enabled} == true")
@Order(value=2)
public class CassandraTsKvExporter
extends MigrationService {
    private final Storage storage;
    private final CassandraService cassandraService;
    @Value(value="${export.cassandra.ts.filter.start_ts:}")
    private Long startTs;
    @Value(value="${export.cassandra.ts.filter.end_ts:}")
    private Long endTs;
    @Value(value="${export.cassandra.ts.filter.partition_size_ms:2678400000}")
    private long partitionSizeMs;
    public static final String TS_KV_TABLE = "ts_kv_cf";
    public static final String TS_KV_PARTITIONS_TABLE = "ts_kv_partitions_cf";
    public static final String TS_KV_FILE = "ts_kv";
    private Writer writer;

    @Override
    protected void start() throws Exception {
        if (this.startTs != null && this.endTs != null && this.startTs > this.endTs) {
            this.log.error("Invalid time range configuration: startTs {} is greater than endTs {}. Aborting Cassandra TS export.", (Object)this.startTs, (Object)this.endTs);
            return;
        }
        if (this.startTs != null || this.endTs != null) {
            this.log.info("Cassandra TS export filter is active. startTs={}, endTs={}, partitionSizeMs={}", new Object[]{this.startTs, this.endTs, this.partitionSizeMs});
        }
        this.storage.newFile(TS_KV_FILE);
        this.writer = this.storage.newWriter(TS_KV_FILE);
        this.storage.readAndProcess(Table.LATEST_KV.getName(), latestKvRow -> this.executor.submit(() -> {
            try {
                this.getTsHistoryAndSave((Map<String, Object>)latestKvRow);
            }
            catch (Exception e) {
                this.log.error("Failed to retrieve timeseries history for {}", latestKvRow, (Object)e);
            }
        }));
    }

    private void getTsHistoryAndSave(Map<String, Object> latestKvRow) {
        String entityType = (String)latestKvRow.get("table_name");
        UUID entityId = (UUID)latestKvRow.get("entity_id");
        String key = (String)latestKvRow.get("key_name");
        Long startTs = this.startTs;
        Long endTs = this.endTs;
        StringBuilder pQuery = new StringBuilder("SELECT partition FROM ts_kv_partitions_cf WHERE entity_type = ? AND entity_id = ? AND key = ?");
        ArrayList<Object> pArgs = new ArrayList<Object>();
        pArgs.add(entityType);
        pArgs.add(entityId);
        pArgs.add(key);
        if (startTs != null) {
            pQuery.append(" AND partition >= ?");
            pArgs.add(startTs - this.partitionSizeMs);
        }
        if (endTs != null) {
            pQuery.append(" AND partition <= ?");
            pArgs.add(endTs);
        }
        List<Long> partitions = this.cassandraService.query(pQuery.toString(), Long.class, pArgs.toArray());
        for (Long partition : partitions) {
            if (startTs != null && partition < startTs - this.partitionSizeMs || endTs != null && partition > endTs) continue;
            StringBuilder query = new StringBuilder("SELECT * FROM ts_kv_cf WHERE entity_type = ? AND entity_id = ? AND key = ? AND partition = ?");
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(entityType);
            args.add(entityId);
            args.add(key);
            args.add(partition);
            if (startTs != null) {
                query.append(" AND ts >= ?");
                args.add(startTs);
            }
            if (endTs != null) {
                query.append(" AND ts <= ?");
                args.add(endTs);
            }
            query.append(" ORDER BY ts");
            ResultSet rows = this.cassandraService.query(query.toString(), args.toArray());
            for (Row row : rows) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (ColumnDefinition columnDefinition : row.getColumnDefinitions()) {
                    String column = columnDefinition.getName().toString();
                    Object value = row.getObject(columnDefinition.getName());
                    if (column.endsWith("_v") && value == null) continue;
                    data.put(column, value);
                }
                this.storage.addToFile(this.writer, data);
                this.reportProcessed(TS_KV_TABLE, data);
            }
        }
    }

    @Override
    protected void afterFinished() throws Exception {
        this.finishedProcessing(TS_KV_TABLE);
        this.writer.close();
    }

    @ConstructorProperties(value={"storage", "cassandraService"})
    @Generated
    public CassandraTsKvExporter(Storage storage, CassandraService cassandraService) {
        this.storage = storage;
        this.cassandraService = cassandraService;
    }
}

