/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.latest_kv.importing;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.utils.Storage;

@Component
@ConditionalOnExpression(value="'${mode}' == 'POSTGRES_LATEST_KV_IMPORT'")
public class PostgresLatestKvImporter
extends MigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgresLatestKvImporter.class);
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final Storage storage;
    @Value(value="${import.postgres.delay_between_queries}")
    private int delayBetweenQueries;
    @Value(value="${import.postgres.ignore_conflicts}")
    private boolean ignoreConflicts;
    private static final String LATEST_KV_TABLE = "ts_kv_latest";
    private Map<String, String> columns;

    @Override
    protected void start() throws Exception {
        this.transactionTemplate.executeWithoutResult(status -> {
            try {
                this.storage.readAndProcess("latest_kv", row -> this.saveRow((Map<String, Object>)row));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void saveRow(Map<String, Object> row) {
        this.prepareRow(row);
        Object columnsStatement = "";
        Object valuesStatement = "";
        for (Map.Entry<String, Object> entry : row.entrySet()) {
            String column = entry.getKey();
            Object value = entry.getValue();
            if (!((String)columnsStatement).isEmpty()) {
                columnsStatement = (String)columnsStatement + ",";
            }
            columnsStatement = (String)columnsStatement + column;
            if (!((String)valuesStatement).isEmpty()) {
                valuesStatement = (String)valuesStatement + ",";
            }
            valuesStatement = (String)valuesStatement + "?";
            if (value instanceof JsonNode) {
                entry.setValue(value.toString());
            }
            String valueType = this.columns.get(column);
            valuesStatement = (String)valuesStatement + "::" + valueType;
        }
        Object query = String.format("INSERT INTO ts_kv_latest (%s) VALUES (%s)", columnsStatement, valuesStatement);
        if (this.ignoreConflicts) {
            query = (String)query + " ON CONFLICT DO NOTHING";
        }
        this.jdbcTemplate.update((String)query, row.values().toArray());
        this.reportProcessed(LATEST_KV_TABLE, row);
        try {
            TimeUnit.MILLISECONDS.sleep(this.delayBetweenQueries);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepareRow(Map<String, Object> row) {
        String keyName = (String)row.remove("key_name");
        Integer keyId = this.jdbcTemplate.queryForList("SELECT key_id FROM ts_kv_dictionary WHERE key = ?", Integer.class, new Object[]{keyName}).stream().findFirst().orElse(null);
        if (keyId == null) {
            this.jdbcTemplate.update("INSERT INTO ts_kv_dictionary (key) VALUES (?)", new Object[]{keyName});
            keyId = (Integer)this.jdbcTemplate.queryForObject("SELECT key_id FROM ts_kv_dictionary WHERE key = ?", Integer.class, new Object[]{keyName});
            log.info("Inserted key '{}' into ts_kv_dictionary (new key id: {})", (Object)keyName, (Object)keyId);
        }
        row.put("key", keyId);
        if (this.columns == null) {
            this.columns = this.jdbcTemplate.queryForList("SELECT column_name, udt_name FROM information_schema.columns WHERE table_schema = 'public' AND table_name = 'ts_kv_latest'").stream().collect(Collectors.toMap(vals -> vals.get("column_name").toString(), vals -> vals.get("udt_name").toString()));
        }
        row.keySet().removeIf(column -> !this.columns.containsKey(column));
    }

    @Override
    protected void afterFinished() throws Exception {
        this.finishedProcessing(LATEST_KV_TABLE);
    }

    @ConstructorProperties(value={"jdbcTemplate", "transactionTemplate", "storage"})
    @Generated
    public PostgresLatestKvImporter(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, Storage storage) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
        this.storage = storage;
    }
}

