/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.latest_kv.exporting;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.beans.ConstructorProperties;
import java.io.Writer;
import java.util.HashMap;
import lombok.Generated;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.utils.CassandraService;
import org.thingsboard.migrator.utils.Storage;

@Component
@ConditionalOnExpression(value="'${mode}' == 'CASSANDRA_LATEST_KV_EXPORT'")
public class CassandraLatestKvExporter
extends MigrationService {
    private final CassandraService cassandraService;
    private final Storage storage;
    private static final String LATEST_KV_TABLE = "ts_kv_latest_cf";
    public static final String LATEST_KV_FILE = "latest_kv";

    @Override
    protected void start() throws Exception {
        this.storage.newFile(LATEST_KV_FILE);
        try (Writer writer = this.storage.newWriter(LATEST_KV_FILE);){
            String query = "SELECT * FROM ts_kv_latest_cf";
            ResultSet rows = this.cassandraService.query(query, new Object[0]);
            for (Row row : rows) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (ColumnDefinition columnDefinition : row.getColumnDefinitions()) {
                    String column = columnDefinition.getName().toString();
                    Object value = row.getObject(columnDefinition.getName());
                    if (column.endsWith("_v") && value == null) continue;
                    if (column.equals("key")) {
                        column = "key_name";
                    }
                    data.put(column, value);
                }
                this.storage.addToFile(writer, data);
                this.reportProcessed(LATEST_KV_TABLE, data);
            }
        }
    }

    @Override
    protected void afterFinished() throws Exception {
        this.finishedProcessing(LATEST_KV_TABLE);
    }

    @ConstructorProperties(value={"cassandraService", "storage"})
    @Generated
    public CassandraLatestKvExporter(CassandraService cassandraService, Storage storage) {
        this.cassandraService = cassandraService;
        this.storage = storage;
    }
}

