/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator;

import jakarta.annotation.PostConstruct;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.thingsboard.migrator.utils.Storage;

public abstract class MigrationService {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ThreadPoolExecutor executor;
    @Autowired
    protected Storage storage;
    @Value(value="${stats_print_interval}")
    private int statsPrintInterval;
    @Value(value="${parallelism_level}")
    private int parallelismLevel;
    protected final ConcurrentMap<Object, AtomicInteger> processed = new ConcurrentHashMap<Object, AtomicInteger>();

    @PostConstruct
    private void init() {
        this.executor = new ThreadPoolExecutor(this.parallelismLevel, this.parallelismLevel, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(5000), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public final void run() throws Exception {
        this.log.info("Starting...");
        this.start();
        this.executor.shutdown();
        this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        this.afterFinished();
        this.log.info("Finished successfully!");
    }

    protected abstract void start() throws Exception;

    protected void afterFinished() throws Exception {
    }

    protected void reportProcessed(Object key, Object data) {
        int n = this.processed.computeIfAbsent(key, k -> new AtomicInteger()).incrementAndGet();
        if (n % this.statsPrintInterval == 0) {
            this.printStats(key, n, data);
        }
    }

    protected void finishedProcessing(Object key) {
        int n = Optional.ofNullable((AtomicInteger)this.processed.remove(key)).map(AtomicInteger::get).orElse(0);
        this.printStats(key, n, null);
    }

    protected void printStats(Object key, int n, Object lastData) {
        if (n > 0) {
            this.log.info("[{}] Processed: {}", key, (Object)(n + (String)(lastData != null ? ". Last: " + StringUtils.abbreviate((String)lastData.toString(), (int)100) : "")));
        }
    }
}

