/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator;

import java.util.List;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.utils.Storage;

@SpringBootApplication
public class MigratorApplication {
    public static void main(String[] args) {
        SpringApplication.run(MigratorApplication.class, (String[])args);
    }

    @Bean
    public ApplicationRunner runner(List<MigrationService> migrationServices, Storage storage) {
        return args -> {
            storage.open();
            for (MigrationService migrationService : migrationServices) {
                migrationService.run();
            }
            storage.close();
        };
    }
}

