/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.utils;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.cassandra.core.CassandraTemplate;
import org.springframework.data.cassandra.core.cql.ArgumentPreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.CachedPreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.ResultSetExtractor;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.RowMapperResultSetExtractor;
import org.springframework.data.cassandra.core.cql.SingleColumnRowMapper;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class CassandraService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraService.class);
    private final CqlOperations cqlOperations;

    public CassandraService(CassandraTemplate cassandraTemplate) {
        this.cqlOperations = cassandraTemplate.getCqlOperations();
    }

    public void execute(String query, Object ... args) {
        this.query(query, args);
    }

    public ResultSet query(String query, Object ... args) {
        return (ResultSet)this.query(query, rs -> rs, args);
    }

    public <T> List<T> query(String query, Class<T> type, Object ... args) {
        return (List)this.query(query, (ResultSetExtractor)new RowMapperResultSetExtractor((RowMapper)SingleColumnRowMapper.newInstance(type)), args);
    }

    private <T> T query(String query, ResultSetExtractor<T> resultSetExtractor, Object ... args) {
        try {
            return (T)this.cqlOperations.query((PreparedStatementCreator)new CachedPreparedStatementCreator(query), (PreparedStatementBinder)new ArgumentPreparedStatementBinder(args), resultSetExtractor);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute Cassandra query: " + query + " with args " + Arrays.toString(args), e);
        }
    }
}

