/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.tenant.importing;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.Table;
import org.thingsboard.migrator.utils.PostgresService;
import org.thingsboard.migrator.utils.SqlPartitionService;
import org.thingsboard.migrator.utils.Storage;

@Service
@ConditionalOnExpression(value="'${mode}' == 'TENANT_DATA_IMPORT' and ${import.postgres.enabled} == true")
@Order(value=1)
public class PostgresTenantDataImporter
extends MigrationService {
    private static final Logger log = LoggerFactory.getLogger(PostgresTenantDataImporter.class);
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final Storage storage;
    private final SqlPartitionService partitionService;
    private final PostgresService postgresService;
    @Value(value="${skipped_tables}")
    private Set<Table> skippedTables;
    @Value(value="${import.postgres.delay_between_queries}")
    private int delayBetweenQueries;
    @Value(value="${import.postgres.enable_partition_creation}")
    private boolean enablePartitionCreation;
    @Value(value="${import.postgres.update_tenant_profile}")
    private boolean updateTenantProfile;
    @Value(value="${import.postgres.update_ts_kv_dictionary}")
    private boolean updateKeyDictionary;
    @Value(value="${import.postgres.resolve_unknown_roles}")
    private boolean resolveUnknownRoles;
    private final Map<Table, Map<String, String>> columns = new HashMap();

    protected void start() throws Exception {
        this.transactionTemplate.executeWithoutResult(status -> {
            this.prepare();
            for (Table table : Table.values()) {
                if (this.skippedTables.contains(table)) continue;
                this.importTableData(table);
            }
            this.tearDown();
        });
    }

    private void importTableData(Table table) {
        this.storage.readAndProcess(table.getName(), row -> this.saveRow(table, row));
        this.finishedProcessing((Object)table.getName());
    }

    private void saveRow(Table table, Map<String, Object> row) {
        row = this.prepareRow(table, row);
        if (table.isPartitioned() && this.enablePartitionCreation) {
            this.partitionService.createPartition(table, row);
        }
        Object columnsStatement = "";
        Object valuesStatement = "";
        for (Map.Entry entry : row.entrySet()) {
            String column = (String)entry.getKey();
            Object value = entry.getValue();
            if (!((String)columnsStatement).isEmpty()) {
                columnsStatement = (String)columnsStatement + ",";
            }
            columnsStatement = (String)columnsStatement + column;
            if (!((String)valuesStatement).isEmpty()) {
                valuesStatement = (String)valuesStatement + ",";
            }
            valuesStatement = (String)valuesStatement + "?";
            if (value instanceof JsonNode) {
                entry.setValue(value.toString());
            } else if (value instanceof String[]) {
                try {
                    entry.setValue(this.jdbcTemplate.getDataSource().getConnection().createArrayOf("text", (String[])value));
                    continue;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            String valueType = (String)((Map)this.columns.get(table)).get(column);
            valuesStatement = (String)valuesStatement + "::" + valueType;
        }
        String query = String.format("INSERT INTO %s (%s) VALUES (%s)", table.getName(), columnsStatement, valuesStatement);
        this.jdbcTemplate.update(query, row.values().toArray());
        this.reportProcessed((Object)table.getName(), (Object)row);
        try {
            TimeUnit.MILLISECONDS.sleep(this.delayBetweenQueries);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    private Map<String, Object> prepareRow(Table table, Map<String, Object> row) {
        if (table == Table.TENANT) {
            if (this.updateTenantProfile) {
                UUID defaultTenantProfile = (UUID)this.jdbcTemplate.queryForList("SELECT id FROM tenant_profile WHERE is_default = TRUE", UUID.class).get(0);
                row = new LinkedHashMap<String, Object>(row);
                row.put("tenant_profile_id", defaultTenantProfile);
            }
        } else if (table == Table.LATEST_KV || table == Table.ATTRIBUTE) {
            String keyName = (String)row.remove("key_name");
            if (this.updateKeyDictionary) {
                Integer keyId = this.jdbcTemplate.queryForList("SELECT key_id FROM key_dictionary WHERE key = ?", Integer.class, new Object[]{keyName}).stream().findFirst().orElse(null);
                if (keyId == null) {
                    keyId = (Integer)this.jdbcTemplate.queryForObject("INSERT INTO key_dictionary (key) VALUES (?) RETURNING key_id", Integer.class, new Object[]{keyName});
                }
                if (table == Table.LATEST_KV) {
                    row.put("key", keyId);
                } else {
                    row.put("attribute_key", keyId);
                }
            }
        } else if (table == Table.GROUP_PERMISSION) {
            UUID roleId = (UUID)row.get("role_id");
            String roleName = (String)row.remove("role_name");
            Boolean roleExists = (Boolean)this.jdbcTemplate.queryForObject("SELECT EXISTS (SELECT * FROM role WHERE id = ?)", Boolean.class, new Object[]{roleId});
            if (!roleExists.booleanValue()) {
                if (!this.resolveUnknownRoles) {
                    throw new IllegalArgumentException("Role with id " + String.valueOf(roleId) + " not found");
                }
                log.info("Role for id {} does not exist. Finding by name {}", (Object)roleId, (Object)roleName);
                Map role = this.jdbcTemplate.queryForList("SELECT * FROM role WHERE name = ?", new Object[]{roleName}).stream().findFirst().orElse(null);
                if (role == null) {
                    throw new IllegalArgumentException("Role not found for name " + roleName);
                }
                row.put("role_id", role.get("id"));
            }
        }
        row.replaceAll((key, value) -> {
            if (value instanceof PostgresService.Blob) {
                PostgresService.Blob blob = (PostgresService.Blob)value;
                return this.postgresService.saveBlob(blob);
            }
            return value;
        });
        row.remove("table_name");
        Object version = row.get("version");
        if (version instanceof Number) {
            row.remove("version");
        }
        Map existingColumns = this.columns.computeIfAbsent(table, t -> this.jdbcTemplate.queryForList("SELECT column_name, udt_name FROM information_schema.columns WHERE table_schema = 'public' AND table_name = '" + table.getName() + "'").stream().collect(Collectors.toMap(vals -> vals.get("column_name").toString(), vals -> vals.get("udt_name").toString())));
        row.keySet().removeIf(column -> {
            boolean unknownColumn;
            boolean bl = unknownColumn = !existingColumns.containsKey(column);
            if (unknownColumn) {
                log.warn("Skipping unknown column {} for table {}", column, (Object)table.getName());
            }
            return unknownColumn;
        });
        return row;
    }

    private void prepare() {
        this.jdbcTemplate.execute("ALTER TABLE ota_package DROP CONSTRAINT IF EXISTS fk_device_profile_ota_package");
        log.info("Temporarily dropped fk_device_profile_ota_package constraint");
    }

    private void tearDown() {
        this.jdbcTemplate.execute("ALTER TABLE ota_package ADD CONSTRAINT fk_device_profile_ota_package FOREIGN KEY (device_profile_id) REFERENCES device_profile (id) ON DELETE CASCADE");
        log.info("Created fk_device_profile_ota_package constraint");
    }

    @ConstructorProperties(value={"jdbcTemplate", "transactionTemplate", "storage", "partitionService", "postgresService"})
    public PostgresTenantDataImporter(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, Storage storage, SqlPartitionService partitionService, PostgresService postgresService) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
        this.storage = storage;
        this.partitionService = partitionService;
        this.postgresService = postgresService;
    }
}

