/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.tenant.importing;

import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.service.tenant.importing.CassandraTsKvImporter;
import org.thingsboard.migrator.utils.CassandraService;
import org.thingsboard.migrator.utils.Storage;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ConditionalOnExpression(value="'${mode}' == 'TENANT_DATA_IMPORT' and ${import.cassandra.enabled} == true")
@Order(value=2)
public class CassandraTsKvImporter
extends MigrationService {
    private final Storage storage;
    private final CassandraService cassandraService;
    private final Map<PartitionKey, Set<Long>> partitions = new WeakHashMap();
    @Value(value="${import.cassandra.ttl}")
    private int tsKvTtlDays;

    protected void start() throws Exception {
        this.storage.readAndProcess("ts_kv", row -> {
            try {
                this.saveTsKv(row);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to save row: " + String.valueOf(row), e);
            }
        });
    }

    private void saveTsKv(Map<String, Object> row) {
        Object dblV;
        Object longV;
        String entityType = (String)row.get("entity_type");
        UUID entityId = (UUID)row.get("entity_id");
        String key = (String)row.get("key");
        PartitionKey partitionKey = PartitionKey.of((String)entityType, (UUID)entityId, (String)key);
        Long partition = ((Number)row.get("partition")).longValue();
        row.put("partition", partition);
        long ttl = TimeUnit.DAYS.toSeconds(this.tsKvTtlDays);
        boolean newPartition = this.partitions.computeIfAbsent(partitionKey, k -> new HashSet()).add(partition);
        if (newPartition) {
            Object query = "INSERT INTO ts_kv_partitions_cf (entity_type, entity_id, key, partition) VALUES (?, ?, ?, ?)";
            if (ttl > 0L) {
                query = (String)query + " USING TTL " + ttl;
            }
            String finalQuery = query;
            this.executor.submit(() -> this.cassandraService.execute(finalQuery, new Object[]{entityType, entityId, key, partition}));
        }
        if ((longV = row.get("long_v")) != null && !(longV instanceof Long)) {
            row.put("long_v", ((Number)longV).longValue());
        }
        if ((dblV = row.get("dbl_v")) != null && !(dblV instanceof Double)) {
            row.put("dbl_v", ((Number)dblV).doubleValue());
        }
        Number ts = (Number)row.get("ts");
        ts = ts.longValue();
        row.put("ts", ts);
        String columnsStmt = String.join((CharSequence)", ", row.keySet());
        String valuesStmt = StringUtils.removeEnd((String)"?,".repeat(row.size()), (String)",");
        Object query = String.format("INSERT INTO ts_kv_cf (%s) VALUES (%s)", columnsStmt, valuesStmt);
        if (ttl > 0L) {
            query = (String)query + " USING TTL " + ttl;
        }
        String finalQuery = query;
        this.executor.submit(() -> {
            this.cassandraService.execute(finalQuery, row.values().toArray());
            this.reportProcessed((Object)"ts_kv_cf", (Object)row);
        });
    }

    protected void afterFinished() throws Exception {
        this.finishedProcessing((Object)"ts_kv_cf");
    }

    @ConstructorProperties(value={"storage", "cassandraService"})
    public CassandraTsKvImporter(Storage storage, CassandraService cassandraService) {
        this.storage = storage;
        this.cassandraService = cassandraService;
    }
}

