/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.utils;

import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.thingsboard.migrator.Table;

@Service
@ConfigurationProperties
public class SqlPartitionService {
    private static final Logger log = LoggerFactory.getLogger(SqlPartitionService.class);
    private final JdbcTemplate jdbcTemplate;
    private Map<String, Integer> partitionSizes;
    private final Map<Table, Set<Long>> partitions = new HashMap();

    public void createPartition(Table table, Map<String, Object> row) {
        long partitionSize = this.getPartitionSize(table);
        long ts = (Long)row.get(table.getPartitionColumn());
        long partitionStart = ts - ts % partitionSize;
        long partitionEnd = partitionStart + partitionSize;
        boolean newPartition = this.partitions.computeIfAbsent(table, t -> new HashSet()).add(partitionStart);
        if (newPartition) {
            String query = String.format("CREATE TABLE IF NOT EXISTS %s_%s PARTITION OF %s FOR VALUES FROM (%s) TO (%s)", table.getName(), partitionStart, table.getName(), partitionStart, partitionEnd);
            log.info("Created partition for table {} ({}-{})", new Object[]{table.getName(), partitionStart, partitionEnd});
            this.jdbcTemplate.execute(query);
        }
    }

    public Map<Long, Long> getPartitions(Table table) {
        long partitionSize = this.getPartitionSize(table);
        return this.jdbcTemplate.queryForList("SELECT tablename FROM pg_tables WHERE tablename LIKE '" + table.getName() + "_%'", String.class).stream().map(partition -> StringUtils.substringAfterLast((String)partition, (String)"_")).map(Long::parseLong).collect(Collectors.toMap(startTs -> startTs, startTs -> startTs + partitionSize));
    }

    private long getPartitionSize(Table table) {
        return TimeUnit.HOURS.toMillis(((Integer)this.partitionSizes.get(table.getPartitionSizeSettingsKey())).intValue());
    }

    @ConstructorProperties(value={"jdbcTemplate"})
    public SqlPartitionService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setPartitionSizes(Map<String, Integer> partitionSizes) {
        this.partitionSizes = partitionSizes;
    }
}

