/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.utils;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.thingsboard.migrator.utils.PostgresService;

@Service
public class PostgresService {
    private static final Logger log = LoggerFactory.getLogger(PostgresService.class);
    private final JdbcTemplate jdbcTemplate;

    public Blob getBlob(long oid) {
        byte[] data = (byte[])this.jdbcTemplate.execute(connection -> {
            connection.setAutoCommit(false);
            try {
                byte[] byArray;
                block12: {
                    LargeObjectManager loManager = this.getLoManager(connection);
                    LargeObject lo = loManager.open(oid, 262144);
                    try {
                        byArray = IOUtils.toByteArray((InputStream)lo.getInputStream());
                        if (lo == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (lo != null) {
                                try {
                                    lo.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    lo.close();
                }
                return byArray;
            }
            finally {
                connection.setAutoCommit(true);
            }
        });
        return new Blob(data);
    }

    public Long saveBlob(Blob blob) {
        return (Long)this.jdbcTemplate.execute(connection -> {
            LargeObjectManager largeObjectManager = this.getLoManager(connection);
            long oid = largeObjectManager.createLO();
            try (LargeObject lo = largeObjectManager.open(oid, 131072);){
                lo.write(blob.data());
            }
            log.info("Created blob {} (data size: {})", (Object)oid, (Object)blob.data().length);
            return oid;
        });
    }

    private LargeObjectManager getLoManager(Connection connection) throws SQLException {
        return connection.unwrap(PgConnection.class).getLargeObjectAPI();
    }

    @ConstructorProperties(value={"jdbcTemplate"})
    public PostgresService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

