/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.migrator.service.tenant.exporting;

import com.datastax.oss.driver.api.core.cql.ColumnDefinition;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.beans.ConstructorProperties;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.thingsboard.migrator.MigrationService;
import org.thingsboard.migrator.Table;
import org.thingsboard.migrator.utils.CassandraService;
import org.thingsboard.migrator.utils.Storage;

@Service
@ConditionalOnExpression(value="'${mode}' == 'TENANT_DATA_EXPORT' and ${export.cassandra.enabled} == true")
@Order(value=2)
public class CassandraTsKvExporter
extends MigrationService {
    private final Storage storage;
    private final CassandraService cassandraService;
    public static final String TS_KV_TABLE = "ts_kv_cf";
    public static final String TS_KV_PARTITIONS_TABLE = "ts_kv_partitions_cf";
    public static final String TS_KV_FILE = "ts_kv";
    private Writer writer;

    protected void start() throws Exception {
        this.storage.newFile(TS_KV_FILE);
        this.writer = this.storage.newWriter(TS_KV_FILE);
        this.storage.readAndProcess(Table.LATEST_KV.getName(), latestKvRow -> this.executor.submit(() -> {
            try {
                this.getTsHistoryAndSave(latestKvRow);
            }
            catch (Exception e) {
                this.log.error("Failed to retrieve timeseries history for {}", latestKvRow, (Object)e);
            }
        }));
    }

    private void getTsHistoryAndSave(Map<String, Object> latestKvRow) {
        String entityType = (String)latestKvRow.get("table_name");
        UUID entityId = (UUID)latestKvRow.get("entity_id");
        String key = (String)latestKvRow.get("key_name");
        List partitions = this.cassandraService.query("SELECT partition FROM ts_kv_partitions_cf WHERE entity_type = ? AND entity_id = ? AND key = ?", Long.class, new Object[]{entityType, entityId, key});
        for (Long partition : partitions) {
            String query = "SELECT * FROM ts_kv_cf WHERE entity_type = ? AND entity_id = ? AND key = ? AND partition = ? ORDER BY ts";
            ResultSet rows = this.cassandraService.query(query, new Object[]{entityType, entityId, key, partition});
            for (Row row : rows) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                for (ColumnDefinition columnDefinition : row.getColumnDefinitions()) {
                    String column = columnDefinition.getName().toString();
                    Object value = row.getObject(columnDefinition.getName());
                    if (column.endsWith("_v") && value == null) continue;
                    data.put(column, value);
                }
                this.storage.addToFile(this.writer, data);
                this.reportProcessed((Object)TS_KV_TABLE, data);
            }
        }
    }

    protected void afterFinished() throws Exception {
        this.finishedProcessing((Object)TS_KV_TABLE);
        this.writer.close();
    }

    @ConstructorProperties(value={"storage", "cassandraService"})
    public CassandraTsKvExporter(Storage storage, CassandraService cassandraService) {
        this.storage = storage;
        this.cassandraService = cassandraService;
    }
}

