/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama.common;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.common.AbstractStreamingChatModelIT;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.PartialResponse;
import dev.langchain4j.model.chat.response.PartialResponseContext;
import dev.langchain4j.model.chat.response.PartialToolCall;
import dev.langchain4j.model.chat.response.PartialToolCallContext;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.LC4jOllamaContainer;
import dev.langchain4j.model.ollama.OllamaChatRequestParameters;
import dev.langchain4j.model.ollama.OllamaImage;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiChatResponseMetadata;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiTokenUsage;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class OllamaStreamingChatModelIT
extends AbstractStreamingChatModelIT {
    private static final Map<String, LC4jOllamaContainer> CONTAINER_MAP = new HashMap<String, LC4jOllamaContainer>();
    private static final String MODEL_WITH_TOOLS = "llama3.1";
    private static LC4jOllamaContainer ollamaWithTools;
    private static final String MODEL_WITH_VISION = "llama3.2-vision";
    private static LC4jOllamaContainer ollamaWithVision;
    private static final String CUSTOM_MODEL_NAME = "llama3.2";
    static final OllamaStreamingChatModel OLLAMA_CHAT_MODEL_WITH_TOOLS;
    static final OllamaStreamingChatModel OLLAMA_CHAT_MODEL_WITH_VISION;
    static final OpenAiStreamingChatModel OPEN_AI_CHAT_MODEL_WITH_TOOLS;
    static final OpenAiStreamingChatModel OPEN_AI_CHAT_MODEL_WITH_VISION;

    OllamaStreamingChatModelIT() {
    }

    protected List<StreamingChatModel> models() {
        return List.of(OLLAMA_CHAT_MODEL_WITH_TOOLS, OPEN_AI_CHAT_MODEL_WITH_TOOLS);
    }

    protected List<StreamingChatModel> modelsSupportingImageInputs() {
        return List.of(OLLAMA_CHAT_MODEL_WITH_VISION, OPEN_AI_CHAT_MODEL_WITH_VISION);
    }

    @Disabled(value="llama 3.1 cannot do it properly")
    protected void should_execute_a_tool_then_answer_respecting_JSON_response_format_with_schema(StreamingChatModel model) {
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @DisabledIf(value="supportsToolChoiceRequired")
    protected void should_fail_if_tool_choice_REQUIRED_is_not_supported(StreamingChatModel model) {
        if (model instanceof OpenAiStreamingChatModel) {
            return;
        }
        super.should_fail_if_tool_choice_REQUIRED_is_not_supported((Object)model);
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormat")
    protected void should_fail_if_JSON_response_format_is_not_supported(StreamingChatModel model) {
        if (model instanceof OpenAiStreamingChatModel) {
            return;
        }
        super.should_fail_if_JSON_response_format_is_not_supported((Object)model);
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormatWithSchema")
    protected void should_fail_if_JSON_response_format_with_schema_is_not_supported(StreamingChatModel model) {
        if (model instanceof OpenAiStreamingChatModel) {
            return;
        }
        super.should_fail_if_JSON_response_format_with_schema_is_not_supported((Object)model);
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsSingleImageInputAsPublicURL")
    protected void should_accept_single_image_as_public_URL(StreamingChatModel model) {
        if (model instanceof OpenAiStreamingChatModel) {
            return;
        }
        super.should_accept_single_image_as_public_URL((Object)model);
    }

    protected StreamingChatModel createModelWith(ChatRequestParameters parameters) {
        String modelName = (String)Utils.getOrDefault((Object)parameters.modelName(), (Object)MODEL_WITH_TOOLS);
        String localOllamaImage = OllamaImage.localOllamaImage(modelName);
        if (!CONTAINER_MAP.containsKey(localOllamaImage) && Utils.isNullOrEmpty((String)AbstractOllamaLanguageModelInfrastructure.OLLAMA_BASE_URL)) {
            LC4jOllamaContainer ollamaContainer = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImage)).withModel(modelName);
            ollamaContainer.start();
            ollamaContainer.commitToImage(localOllamaImage);
            CONTAINER_MAP.put(localOllamaImage, ollamaContainer);
        }
        OllamaStreamingChatModel.OllamaStreamingChatModelBuilder ollamaStreamingChatModelBuilder = (OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(CONTAINER_MAP.get(localOllamaImage)))).defaultRequestParameters(parameters)).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true));
        if (parameters.modelName() == null) {
            ollamaStreamingChatModelBuilder.modelName(modelName);
        }
        return ollamaStreamingChatModelBuilder.build();
    }

    protected String customModelName() {
        return CUSTOM_MODEL_NAME;
    }

    protected ChatRequestParameters createIntegrationSpecificParameters(int maxOutputTokens) {
        return ((OllamaChatRequestParameters.Builder)OllamaChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens))).build();
    }

    protected boolean supportsToolChoiceRequired() {
        return false;
    }

    protected boolean supportsMultipleImageInputsAsBase64EncodedStrings() {
        return false;
    }

    protected boolean supportsMultipleImageInputsAsPublicURLs() {
        return false;
    }

    protected boolean assertResponseId() {
        return false;
    }

    protected boolean assertToolId(StreamingChatModel model) {
        return model instanceof OpenAiStreamingChatModel;
    }

    protected boolean assertTimesOnPartialResponseWasCalled() {
        return false;
    }

    public StreamingChatModel createModelWith(ChatModelListener listener) {
        return ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithTools))).modelName(MODEL_WITH_TOOLS)).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).timeout(Duration.ofSeconds(180L))).listeners(List.of(listener))).build();
    }

    protected Class<? extends ChatResponseMetadata> chatResponseMetadataType(StreamingChatModel streamingChatModel) {
        if (streamingChatModel instanceof OpenAiStreamingChatModel) {
            return OpenAiChatResponseMetadata.class;
        }
        if (streamingChatModel instanceof OllamaStreamingChatModel) {
            return ChatResponseMetadata.class;
        }
        throw new IllegalStateException("Unknown model type: " + String.valueOf(streamingChatModel.getClass()));
    }

    protected Class<? extends TokenUsage> tokenUsageType(StreamingChatModel streamingChatModel) {
        if (streamingChatModel instanceof OpenAiStreamingChatModel) {
            return OpenAiTokenUsage.class;
        }
        if (streamingChatModel instanceof OllamaStreamingChatModel) {
            return TokenUsage.class;
        }
        throw new IllegalStateException("Unknown model type: " + String.valueOf(streamingChatModel.getClass()));
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, String id, StreamingChatModel model) {
        if (model instanceof OpenAiStreamingChatModel) {
            ((StreamingChatResponseHandler)io.verify((Object)handler)).onPartialToolCall((PartialToolCall)ArgumentMatchers.eq((Object)OllamaStreamingChatModelIT.partial((int)0, (String)id, (String)"getWeather", (String)"{\"city\":\"Munich\"}")), (PartialToolCallContext)ArgumentMatchers.any());
        }
        ((StreamingChatResponseHandler)io.verify((Object)handler)).onCompleteToolCall(OllamaStreamingChatModelIT.complete((int)0, (String)id, (String)"getWeather", (String)"{\"city\":\"Munich\"}"));
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, StreamingChatModel model) {
        if (model instanceof OpenAiStreamingChatModel) {
            ((StreamingChatResponseHandler)io.verify((Object)handler)).onPartialToolCall((PartialToolCall)ArgumentMatchers.argThat(toolCall -> toolCall.index() == 0 && !toolCall.id().isBlank() && toolCall.name().equals("get_current_time") && toolCall.partialArguments().equals("{}")), (PartialToolCallContext)ArgumentMatchers.any());
        }
        ((StreamingChatResponseHandler)io.verify((Object)handler, Mockito.atLeast((int)0))).onPartialResponse((PartialResponse)ArgumentMatchers.any(), (PartialResponseContext)ArgumentMatchers.any());
        ((StreamingChatResponseHandler)io.verify((Object)handler)).onCompleteToolCall((CompleteToolCall)ArgumentMatchers.argThat(request -> request.index() == 0 && request.toolExecutionRequest().name().equals("get_current_time") && request.toolExecutionRequest().arguments().equals("{}")));
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, String id1, String id2, StreamingChatModel model) {
        this.verifyToolCallbacks(handler, io, id1, model);
        if (model instanceof OpenAiStreamingChatModel) {
            ((StreamingChatResponseHandler)io.verify((Object)handler)).onPartialToolCall((PartialToolCall)ArgumentMatchers.eq((Object)OllamaStreamingChatModelIT.partial((int)1, (String)id2, (String)"getTime", (String)"{\"country\":\"France\"}")), (PartialToolCallContext)ArgumentMatchers.any());
        }
        ((StreamingChatResponseHandler)io.verify((Object)handler)).onCompleteToolCall(OllamaStreamingChatModelIT.complete((int)1, (String)id2, (String)"getTime", (String)"{\"country\":\"France\"}"));
    }

    protected boolean supportsPartialToolStreaming(StreamingChatModel model) {
        return model instanceof OpenAiStreamingChatModel;
    }

    static {
        if (Utils.isNullOrEmpty((String)AbstractOllamaLanguageModelInfrastructure.OLLAMA_BASE_URL)) {
            String localOllamaImageWithTools = OllamaImage.localOllamaImage(MODEL_WITH_TOOLS);
            ollamaWithTools = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImageWithTools)).withModel(MODEL_WITH_TOOLS).withModel(CUSTOM_MODEL_NAME);
            ollamaWithTools.start();
            ollamaWithTools.commitToImage(localOllamaImageWithTools);
            String localOllamaImageWithVision = OllamaImage.localOllamaImage(MODEL_WITH_VISION);
            ollamaWithVision = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImageWithVision)).withModel(MODEL_WITH_VISION).withModel(CUSTOM_MODEL_NAME);
            ollamaWithVision.start();
            ollamaWithVision.commitToImage(localOllamaImageWithVision);
            CONTAINER_MAP.put(localOllamaImageWithTools, ollamaWithTools);
            CONTAINER_MAP.put(localOllamaImageWithVision, ollamaWithVision);
        }
        OLLAMA_CHAT_MODEL_WITH_TOOLS = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithTools))).modelName(MODEL_WITH_TOOLS)).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).timeout(Duration.ofSeconds(180L))).build();
        OLLAMA_CHAT_MODEL_WITH_VISION = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithVision))).modelName(MODEL_WITH_VISION)).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(false))).logResponses(Boolean.valueOf(true))).timeout(Duration.ofSeconds(180L))).build();
        OPEN_AI_CHAT_MODEL_WITH_TOOLS = OpenAiStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithTools) + "/v1").modelName(MODEL_WITH_TOOLS).temperature(Double.valueOf(0.0)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).timeout(Duration.ofSeconds(180L)).build();
        OPEN_AI_CHAT_MODEL_WITH_VISION = OpenAiStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithVision) + "/v1").modelName(MODEL_WITH_VISION).temperature(Double.valueOf(0.0)).logRequests(Boolean.valueOf(false)).logResponses(Boolean.valueOf(true)).timeout(Duration.ofSeconds(180L)).build();
    }
}

