/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama.common;

import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.ollama.common.OllamaStreamingChatModelIT;
import dev.langchain4j.model.openai.OpenAiChatResponseMetadata;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiTokenUsage;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.common.AbstractStreamingAiServiceIT;
import java.util.List;

class OllamaStreamingAiServiceIT
extends AbstractStreamingAiServiceIT {
    OllamaStreamingAiServiceIT() {
    }

    protected List<StreamingChatModel> models() {
        return List.of(OllamaStreamingChatModelIT.OLLAMA_CHAT_MODEL_WITH_TOOLS, OllamaStreamingChatModelIT.OPEN_AI_CHAT_MODEL_WITH_TOOLS);
    }

    protected Class<? extends ChatResponseMetadata> chatResponseMetadataType(StreamingChatModel streamingChatModel) {
        if (streamingChatModel instanceof OpenAiStreamingChatModel) {
            return OpenAiChatResponseMetadata.class;
        }
        if (streamingChatModel instanceof OllamaStreamingChatModel) {
            return ChatResponseMetadata.class;
        }
        throw new IllegalStateException("Unknown model type: " + String.valueOf(streamingChatModel.getClass()));
    }

    protected Class<? extends TokenUsage> tokenUsageType(StreamingChatModel streamingChatModel) {
        if (streamingChatModel instanceof OpenAiStreamingChatModel) {
            return OpenAiTokenUsage.class;
        }
        if (streamingChatModel instanceof OllamaStreamingChatModel) {
            return TokenUsage.class;
        }
        throw new IllegalStateException("Unknown model type: " + String.valueOf(streamingChatModel.getClass()));
    }
}

