/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama.common;

import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.common.AbstractChatModelIT;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.LC4jOllamaContainer;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaChatRequestParameters;
import dev.langchain4j.model.ollama.OllamaImage;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiChatResponseMetadata;
import dev.langchain4j.model.openai.OpenAiStreamingChatModel;
import dev.langchain4j.model.openai.OpenAiTokenUsage;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class OllamaChatModelIT
extends AbstractChatModelIT {
    private static final Map<String, LC4jOllamaContainer> CONTAINER_MAP = new HashMap<String, LC4jOllamaContainer>();
    private static final String MODEL_WITH_TOOLS = "llama3.1";
    private static LC4jOllamaContainer ollamaWithTools;
    private static final String MODEL_WITH_VISION = "llama3.2-vision";
    private static LC4jOllamaContainer ollamaWithVision;
    private static final String CUSTOM_MODEL_NAME = "llama3.2";
    static final OllamaChatModel OLLAMA_CHAT_MODEL_WITH_TOOLS;
    static final OllamaChatModel OLLAMA_CHAT_MODEL_WITH_VISION;
    static final OpenAiChatModel OPEN_AI_CHAT_MODEL_WITH_TOOLS;
    static final OpenAiChatModel OPEN_AI_CHAT_MODEL_WITH_VISION;

    OllamaChatModelIT() {
    }

    protected List<ChatModel> models() {
        return List.of(OLLAMA_CHAT_MODEL_WITH_TOOLS, OPEN_AI_CHAT_MODEL_WITH_TOOLS);
    }

    protected List<ChatModel> modelsSupportingImageInputs() {
        return List.of(OLLAMA_CHAT_MODEL_WITH_VISION, OPEN_AI_CHAT_MODEL_WITH_VISION);
    }

    @Disabled(value="llama 3.1 cannot do it properly")
    protected void should_execute_a_tool_then_answer_respecting_JSON_response_format_with_schema(ChatModel model) {
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @DisabledIf(value="supportsToolChoiceRequired")
    protected void should_fail_if_tool_choice_REQUIRED_is_not_supported(ChatModel model) {
        if (model instanceof OpenAiChatModel) {
            return;
        }
        super.should_fail_if_tool_choice_REQUIRED_is_not_supported((Object)model);
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormat")
    protected void should_fail_if_JSON_response_format_is_not_supported(ChatModel model) {
        if (model instanceof OpenAiChatModel) {
            return;
        }
        super.should_fail_if_JSON_response_format_is_not_supported((Object)model);
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormatWithSchema")
    protected void should_fail_if_JSON_response_format_with_schema_is_not_supported(ChatModel model) {
        if (model instanceof OpenAiChatModel) {
            return;
        }
        super.should_fail_if_JSON_response_format_with_schema_is_not_supported((Object)model);
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsSingleImageInputAsPublicURL")
    protected void should_accept_single_image_as_public_URL(ChatModel model) {
        if (model instanceof OpenAiChatModel) {
            return;
        }
        super.should_accept_single_image_as_public_URL((Object)model);
    }

    protected ChatModel createModelWith(ChatRequestParameters parameters) {
        String modelName = (String)Utils.getOrDefault((Object)parameters.modelName(), (Object)MODEL_WITH_TOOLS);
        String localOllamaImage = OllamaImage.localOllamaImage(modelName);
        if (!CONTAINER_MAP.containsKey(localOllamaImage) && Utils.isNullOrEmpty((String)AbstractOllamaLanguageModelInfrastructure.OLLAMA_BASE_URL)) {
            LC4jOllamaContainer ollamaContainer = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImage)).withModel(modelName);
            ollamaContainer.start();
            ollamaContainer.commitToImage(localOllamaImage);
            CONTAINER_MAP.put(localOllamaImage, ollamaContainer);
        }
        OllamaChatModel.OllamaChatModelBuilder ollamaChatModelBuilder = (OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(CONTAINER_MAP.get(localOllamaImage)))).defaultRequestParameters(parameters)).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true));
        if (parameters.modelName() == null) {
            ollamaChatModelBuilder.modelName(modelName);
        }
        return ollamaChatModelBuilder.build();
    }

    protected String customModelName() {
        return CUSTOM_MODEL_NAME;
    }

    protected ChatRequestParameters createIntegrationSpecificParameters(int maxOutputTokens) {
        return ((OllamaChatRequestParameters.Builder)OllamaChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens))).build();
    }

    protected boolean supportsToolChoiceRequired() {
        return false;
    }

    protected boolean supportsMultipleImageInputsAsBase64EncodedStrings() {
        return false;
    }

    protected boolean supportsMultipleImageInputsAsPublicURLs() {
        return false;
    }

    protected boolean assertResponseId() {
        return false;
    }

    protected boolean assertToolId(ChatModel model) {
        return model instanceof OpenAiStreamingChatModel;
    }

    protected Class<? extends ChatResponseMetadata> chatResponseMetadataType(ChatModel chatModel) {
        if (chatModel instanceof OpenAiChatModel) {
            return OpenAiChatResponseMetadata.class;
        }
        if (chatModel instanceof OllamaChatModel) {
            return ChatResponseMetadata.class;
        }
        throw new IllegalStateException("Unknown model type: " + String.valueOf(chatModel.getClass()));
    }

    protected Class<? extends TokenUsage> tokenUsageType(ChatModel chatModel) {
        if (chatModel instanceof OpenAiChatModel) {
            return OpenAiTokenUsage.class;
        }
        if (chatModel instanceof OllamaChatModel) {
            return TokenUsage.class;
        }
        throw new IllegalStateException("Unknown model type: " + String.valueOf(chatModel.getClass()));
    }

    static {
        if (Utils.isNullOrEmpty((String)AbstractOllamaLanguageModelInfrastructure.OLLAMA_BASE_URL)) {
            String localOllamaImageWithTools = OllamaImage.localOllamaImage(MODEL_WITH_TOOLS);
            ollamaWithTools = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImageWithTools)).withModel(MODEL_WITH_TOOLS).withModel(CUSTOM_MODEL_NAME);
            ollamaWithTools.start();
            ollamaWithTools.commitToImage(localOllamaImageWithTools);
            String localOllamaImageWithVision = OllamaImage.localOllamaImage(MODEL_WITH_VISION);
            ollamaWithVision = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImageWithVision)).withModel(MODEL_WITH_VISION).withModel(CUSTOM_MODEL_NAME);
            ollamaWithVision.start();
            ollamaWithVision.commitToImage(localOllamaImageWithVision);
            CONTAINER_MAP.put(localOllamaImageWithTools, ollamaWithTools);
            CONTAINER_MAP.put(localOllamaImageWithVision, ollamaWithVision);
        }
        OLLAMA_CHAT_MODEL_WITH_TOOLS = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithTools))).modelName(MODEL_WITH_TOOLS)).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).timeout(Duration.ofSeconds(180L))).build();
        OLLAMA_CHAT_MODEL_WITH_VISION = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithVision))).modelName(MODEL_WITH_VISION)).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(false))).logResponses(Boolean.valueOf(true))).timeout(Duration.ofSeconds(180L))).build();
        OPEN_AI_CHAT_MODEL_WITH_TOOLS = OpenAiChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithTools) + "/v1").modelName(MODEL_WITH_TOOLS).temperature(Double.valueOf(0.0)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).timeout(Duration.ofSeconds(180L)).build();
        OPEN_AI_CHAT_MODEL_WITH_VISION = OpenAiChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollamaWithVision) + "/v1").modelName(MODEL_WITH_VISION).temperature(Double.valueOf(0.0)).logRequests(Boolean.valueOf(false)).logResponses(Boolean.valueOf(true)).timeout(Duration.ofSeconds(180L)).build();
    }
}

