/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama.common;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.common.OllamaChatModelIT;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.model.openai.OpenAiTokenUsage;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.common.AbstractAiServiceIT;
import java.util.List;

class OllamaAiServiceIT
extends AbstractAiServiceIT {
    OllamaAiServiceIT() {
    }

    protected List<ChatModel> models() {
        return List.of(OllamaChatModelIT.OLLAMA_CHAT_MODEL_WITH_TOOLS, OllamaChatModelIT.OPEN_AI_CHAT_MODEL_WITH_TOOLS);
    }

    protected Class<? extends TokenUsage> tokenUsageType(ChatModel chatModel) {
        if (chatModel instanceof OpenAiChatModel) {
            return OpenAiTokenUsage.class;
        }
        if (chatModel instanceof OllamaChatModel) {
            return TokenUsage.class;
        }
        throw new IllegalStateException("Unknown model type: " + String.valueOf(chatModel.getClass()));
    }
}

