/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.TestStreamingResponseHandler;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.AbstractOllamaStructuredOutputLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaJsonUtils;
import dev.langchain4j.model.ollama.OllamaLanguageModel;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.ollama.OllamaStreamingLanguageModel;
import dev.langchain4j.model.output.Response;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaStructuredOutputIT
extends AbstractOllamaStructuredOutputLanguageModelInfrastructure {
    JsonObjectSchema schema = JsonObjectSchema.builder().addProperty("name", (JsonSchemaElement)JsonStringSchema.builder().build()).addProperty("capital", (JsonSchemaElement)JsonStringSchema.builder().build()).addProperty("languages", (JsonSchemaElement)JsonArraySchema.builder().items((JsonSchemaElement)JsonStringSchema.builder().build()).build()).required(new String[]{"name", "capital", "languages"}).build();

    OllamaStructuredOutputIT() {
    }

    @Test
    void should_generate_structured_output_using_response_format() {
        OllamaChatModel ollamaChatModel = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("llama3.1")).temperature(Double.valueOf(0.0))).responseFormat(ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().rootElement((JsonSchemaElement)this.schema).build()).build())).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        ChatResponse chatResponse = ollamaChatModel.chat(new ChatMessage[]{UserMessage.from((String)"Tell me about Canada.")});
        String response = chatResponse.aiMessage().text();
        CountryInfo countryInfo = (CountryInfo)OllamaJsonUtils.fromJson((String)response, CountryInfo.class);
        Assertions.assertThat((String)countryInfo.name()).isEqualTo("Canada");
        Assertions.assertThat((String)countryInfo.capital()).isEqualTo("Ottawa");
        Assertions.assertThat(countryInfo.languages()).contains((Object[])new String[]{"English", "French"});
    }

    @Test
    void should_generate_structured_output_using_response_format_streaming() throws Exception {
        OllamaStreamingChatModel streamingOllamaChatModelWithResponseFormat = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("llama3.1")).temperature(Double.valueOf(0.0))).responseFormat(ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().rootElement((JsonSchemaElement)this.schema).build()).build())).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        final CompletableFuture secondFutureResponse = new CompletableFuture();
        streamingOllamaChatModelWithResponseFormat.chat("Tell me about Canada.", new StreamingChatResponseHandler(){
            final /* synthetic */ OllamaStructuredOutputIT this$0;
            {
                this.this$0 = this$0;
            }

            public void onPartialResponse(String partialResponse) {
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                secondFutureResponse.complete(completeResponse);
            }

            public void onError(Throwable error) {
                secondFutureResponse.completeExceptionally(error);
            }
        });
        ChatResponse secondResponse = (ChatResponse)secondFutureResponse.get(30L, TimeUnit.SECONDS);
        AiMessage secondAiMessage = secondResponse.aiMessage();
        CountryInfo countryInfo = (CountryInfo)OllamaJsonUtils.fromJson((String)secondAiMessage.text(), CountryInfo.class);
        Assertions.assertThat((String)countryInfo.name()).isEqualTo("Canada");
        Assertions.assertThat((String)countryInfo.capital()).isEqualTo("Ottawa");
        Assertions.assertThat(countryInfo.languages()).contains((Object[])new String[]{"English", "French"});
    }

    @Test
    void language_model_should_generate_structured_output() {
        OllamaLanguageModel languageModel = OllamaLanguageModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama)).modelName("llama3.1").temperature(Double.valueOf(0.0)).responseFormat(ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().rootElement((JsonSchemaElement)this.schema).build()).build()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
        Response generated = languageModel.generate("Tell me about Canada.");
        CountryInfo countryInfo = (CountryInfo)OllamaJsonUtils.fromJson((String)((String)generated.content()), CountryInfo.class);
        Assertions.assertThat((String)countryInfo.name()).isEqualTo("Canada");
        Assertions.assertThat((String)countryInfo.capital()).isEqualTo("Ottawa");
        Assertions.assertThat(countryInfo.languages()).contains((Object[])new String[]{"English", "French"});
    }

    @Test
    void streaming_language_model_should_generate_structured_output() {
        OllamaStreamingLanguageModel languageModel = OllamaStreamingLanguageModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama)).modelName("llama3.1").temperature(Double.valueOf(0.0)).responseFormat(ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().rootElement((JsonSchemaElement)this.schema).build()).build()).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();
        TestStreamingResponseHandler handler = new TestStreamingResponseHandler();
        languageModel.generate("Tell me about Canada.", (StreamingResponseHandler)handler);
        Response generated = handler.get();
        CountryInfo countryInfo = (CountryInfo)OllamaJsonUtils.fromJson((String)((String)generated.content()), CountryInfo.class);
        Assertions.assertThat((String)countryInfo.name()).isEqualTo("Canada");
        Assertions.assertThat((String)countryInfo.capital()).isEqualTo("Ottawa");
        Assertions.assertThat(countryInfo.languages()).contains((Object[])new String[]{"English", "French"});
    }

    record CountryInfo(String name, String capital, List<String> languages) {
    }
}

