/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.exception.HttpException;
import dev.langchain4j.exception.ModelNotFoundException;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.TestStreamingResponseHandler;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaStreamingLanguageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.concurrent.CompletableFuture;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaStreamingLanguageModelIT
extends AbstractOllamaLanguageModelInfrastructure {
    OllamaStreamingLanguageModelIT() {
    }

    @Test
    void should_stream_answer() {
        String prompt = "What is the capital of Germany?";
        OllamaStreamingLanguageModel model = OllamaStreamingLanguageModel.builder().baseUrl(OllamaStreamingLanguageModelIT.ollamaBaseUrl(ollama)).modelName("tinydolphin").temperature(Double.valueOf(0.0)).build();
        TestStreamingResponseHandler handler = new TestStreamingResponseHandler();
        model.generate(prompt, (StreamingResponseHandler)handler);
        Response response = handler.get();
        String answer = (String)response.content();
        Assertions.assertThat((String)answer).contains(new CharSequence[]{"Berlin"});
        Assertions.assertThat((String)((String)response.content())).isEqualTo(answer);
        TokenUsage tokenUsage = response.tokenUsage();
        Assertions.assertThat((Integer)tokenUsage.inputTokenCount()).isGreaterThan(0);
        Assertions.assertThat((Integer)tokenUsage.outputTokenCount()).isGreaterThan(0);
        Assertions.assertThat((Integer)tokenUsage.totalTokenCount()).isEqualTo(tokenUsage.inputTokenCount() + tokenUsage.outputTokenCount());
        Assertions.assertThat((Comparable)response.finishReason()).isNull();
    }

    @Test
    void should_respect_numPredict() {
        int numPredict = 1;
        OllamaStreamingLanguageModel model = OllamaStreamingLanguageModel.builder().baseUrl(OllamaStreamingLanguageModelIT.ollamaBaseUrl(ollama)).modelName("tinydolphin").numPredict(Integer.valueOf(numPredict)).temperature(Double.valueOf(0.0)).build();
        String prompt = "What is the capital of Germany?";
        TestStreamingResponseHandler handler = new TestStreamingResponseHandler();
        model.generate(prompt, (StreamingResponseHandler)handler);
        Response response = handler.get();
        String answer = (String)response.content();
        Assertions.assertThat((String)answer).doesNotContain(new CharSequence[]{"Berlin"});
        Assertions.assertThat((String)((String)response.content())).isEqualTo(answer);
        Assertions.assertThat((Integer)response.tokenUsage().outputTokenCount()).isBetween(Integer.valueOf(numPredict), Integer.valueOf(numPredict + 2));
    }

    @Test
    void should_stream_valid_json() {
        OllamaStreamingLanguageModel model = OllamaStreamingLanguageModel.builder().baseUrl(OllamaStreamingLanguageModelIT.ollamaBaseUrl(ollama)).modelName("tinydolphin").responseFormat(ResponseFormat.JSON).temperature(Double.valueOf(0.0)).build();
        String prompt = "Return JSON with two fields: name and age of John Doe, 42 years old.";
        TestStreamingResponseHandler handler = new TestStreamingResponseHandler();
        model.generate(prompt, (StreamingResponseHandler)handler);
        Response response = handler.get();
        String answer = (String)response.content();
        Assertions.assertThat((String)answer).isEqualToIgnoringWhitespace((CharSequence)"{\"name\": \"John Doe\", \"age\": 42}");
        Assertions.assertThat((String)((String)response.content())).isEqualTo(answer);
    }

    @Test
    void should_propagate_failure_to_handler_onError() throws Exception {
        String wrongModelName = "banana";
        OllamaStreamingLanguageModel model = OllamaStreamingLanguageModel.builder().baseUrl(OllamaStreamingLanguageModelIT.ollamaBaseUrl(ollama)).modelName(wrongModelName).build();
        final CompletableFuture future = new CompletableFuture();
        model.generate("does not matter", (StreamingResponseHandler)new StreamingResponseHandler<String>(){
            final /* synthetic */ OllamaStreamingLanguageModelIT this$0;
            {
                this.this$0 = this$0;
            }

            public void onNext(String token) {
                future.completeExceptionally(new Exception("onNext should never be called"));
            }

            public void onComplete(Response<String> response) {
                future.completeExceptionally(new Exception("onComplete should never be called"));
            }

            public void onError(Throwable error) {
                future.complete(error);
            }
        });
        Throwable throwable = (Throwable)future.get();
        Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(ModelNotFoundException.class);
        Assertions.assertThat((String)throwable.getMessage()).contains(new CharSequence[]{"banana", "not found"});
        Assertions.assertThat((Throwable)throwable).hasCauseExactlyInstanceOf(HttpException.class);
        Assertions.assertThat((int)((HttpException)throwable.getCause()).statusCode()).isEqualTo(404);
    }
}

