/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.JsonTestUtils;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.MockHttpClientBuilder;
import dev.langchain4j.http.client.SpyingHttpClient;
import dev.langchain4j.http.client.jdk.JdkHttpClient;
import dev.langchain4j.model.chat.TestStreamingChatResponseHandler;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.PartialResponse;
import dev.langchain4j.model.chat.response.PartialResponseContext;
import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.PartialThinkingContext;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.AbstractOllamaThinkingModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

class OllamaStreamingChatModelThinkingIT
extends AbstractOllamaThinkingModelInfrastructure {
    private final SpyingHttpClient spyingHttpClient = new SpyingHttpClient((HttpClient)JdkHttpClient.builder().build());

    OllamaStreamingChatModelThinkingIT() {
    }

    @Test
    void should_think_and_return_thinking() {
        boolean think = true;
        boolean returnThinking = true;
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().httpClientBuilder((HttpClientBuilder)new MockHttpClientBuilder((HttpClient)this.spyingHttpClient))).baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(Boolean.valueOf(think))).returnThinking(Boolean.valueOf(returnThinking))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage1 = UserMessage.from((String)"What is the capital of Germany?");
        TestStreamingChatResponseHandler spyHandler1 = (TestStreamingChatResponseHandler)Mockito.spy((Object)new TestStreamingChatResponseHandler());
        model.chat(List.of(userMessage1), (StreamingChatResponseHandler)spyHandler1);
        AiMessage aiMessage1 = spyHandler1.get().aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage1.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage1.thinking()).isNotBlank()).isEqualTo(spyHandler1.getThinking());
        InOrder inOrder1 = Mockito.inOrder((Object[])new Object[]{spyHandler1});
        ((TestStreamingChatResponseHandler)inOrder1.verify((Object)spyHandler1)).get();
        ((TestStreamingChatResponseHandler)inOrder1.verify((Object)spyHandler1, Mockito.atLeastOnce())).onPartialThinking((PartialThinking)ArgumentMatchers.any(), (PartialThinkingContext)ArgumentMatchers.any());
        ((TestStreamingChatResponseHandler)inOrder1.verify((Object)spyHandler1, Mockito.atLeastOnce())).onPartialResponse((PartialResponse)ArgumentMatchers.any(), (PartialResponseContext)ArgumentMatchers.any());
        ((TestStreamingChatResponseHandler)inOrder1.verify((Object)spyHandler1)).onCompleteResponse((ChatResponse)ArgumentMatchers.any());
        ((TestStreamingChatResponseHandler)inOrder1.verify((Object)spyHandler1)).getThinking();
        inOrder1.verifyNoMoreInteractions();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{spyHandler1});
        UserMessage userMessage2 = UserMessage.from((String)"What is the capital of France?");
        TestStreamingChatResponseHandler handler2 = new TestStreamingChatResponseHandler();
        model.chat(List.of(userMessage1, aiMessage1, userMessage2), (StreamingChatResponseHandler)handler2);
        AiMessage aiMessage2 = handler2.get().aiMessage();
        Assertions.assertThat((String)aiMessage2.text()).containsIgnoringCase((CharSequence)"Paris");
        Assertions.assertThat((String)aiMessage2.thinking()).isNotBlank();
        List httpRequests = this.spyingHttpClient.requests();
        Assertions.assertThat((List)httpRequests).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((HttpRequest)httpRequests.get(1)).body()).contains(new CharSequence[]{JsonTestUtils.jsonify((String)aiMessage1.text())})).doesNotContain(new CharSequence[]{JsonTestUtils.jsonify((String)aiMessage1.thinking())});
    }

    @Test
    void should_think_and_NOT_return_thinking() {
        boolean think = true;
        boolean returnThinking = false;
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(Boolean.valueOf(think))).returnThinking(Boolean.valueOf(returnThinking))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        String userMessage = "What is the capital of Germany?";
        TestStreamingChatResponseHandler spyHandler = (TestStreamingChatResponseHandler)Mockito.spy((Object)new TestStreamingChatResponseHandler());
        model.chat(userMessage, (StreamingChatResponseHandler)spyHandler);
        AiMessage aiMessage = spyHandler.get().aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        Assertions.assertThat((String)aiMessage.thinking()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyHandler});
        ((TestStreamingChatResponseHandler)inOrder.verify((Object)spyHandler, Mockito.atLeastOnce())).onPartialResponse((PartialResponse)ArgumentMatchers.any(), (PartialResponseContext)ArgumentMatchers.any());
        ((TestStreamingChatResponseHandler)inOrder.verify((Object)spyHandler)).onCompleteResponse((ChatResponse)ArgumentMatchers.any());
        inOrder.verifyNoMoreInteractions();
        ((TestStreamingChatResponseHandler)Mockito.verify((Object)spyHandler)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{spyHandler});
    }

    @Test
    void should_NOT_think() {
        boolean think = false;
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(Boolean.valueOf(think))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        String userMessage = "What is the capital of Germany?";
        TestStreamingChatResponseHandler spyHandler = (TestStreamingChatResponseHandler)Mockito.spy((Object)new TestStreamingChatResponseHandler());
        model.chat(userMessage, (StreamingChatResponseHandler)spyHandler);
        AiMessage aiMessage = spyHandler.get().aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        Assertions.assertThat((String)aiMessage.thinking()).isNull();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyHandler});
        ((TestStreamingChatResponseHandler)inOrder.verify((Object)spyHandler, Mockito.atLeastOnce())).onPartialResponse((PartialResponse)ArgumentMatchers.any(), (PartialResponseContext)ArgumentMatchers.any());
        ((TestStreamingChatResponseHandler)inOrder.verify((Object)spyHandler)).onCompleteResponse((ChatResponse)ArgumentMatchers.any());
        inOrder.verifyNoMoreInteractions();
        ((TestStreamingChatResponseHandler)Mockito.verify((Object)spyHandler)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{spyHandler});
    }

    @Test
    void should_think_and_return_thinking_when_think_is_not_set() {
        Boolean think = null;
        boolean returnThinking = true;
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(think)).returnThinking(Boolean.valueOf(returnThinking))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        String userMessage = "What is the capital of Germany?";
        TestStreamingChatResponseHandler spyHandler = (TestStreamingChatResponseHandler)Mockito.spy((Object)new TestStreamingChatResponseHandler());
        model.chat(userMessage, (StreamingChatResponseHandler)spyHandler);
        AiMessage aiMessage = spyHandler.get().aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        Assertions.assertThat((String)aiMessage.thinking()).isNotEmpty();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{spyHandler});
        ((TestStreamingChatResponseHandler)inOrder.verify((Object)spyHandler, Mockito.atLeastOnce())).onPartialThinking((PartialThinking)ArgumentMatchers.any(), (PartialThinkingContext)ArgumentMatchers.any());
        ((TestStreamingChatResponseHandler)inOrder.verify((Object)spyHandler, Mockito.atLeastOnce())).onPartialResponse((PartialResponse)ArgumentMatchers.any(), (PartialResponseContext)ArgumentMatchers.any());
        ((TestStreamingChatResponseHandler)inOrder.verify((Object)spyHandler)).onCompleteResponse((ChatResponse)ArgumentMatchers.any());
        inOrder.verifyNoMoreInteractions();
        ((TestStreamingChatResponseHandler)Mockito.verify((Object)spyHandler)).get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{spyHandler});
    }
}

