/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.HttpException;
import dev.langchain4j.exception.ModelNotFoundException;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.TestStreamingChatResponseHandler;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaChatModelIT;
import dev.langchain4j.model.ollama.OllamaStreamingChatModel;
import dev.langchain4j.model.output.FinishReason;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class OllamaStreamingChatModelIT
extends AbstractOllamaLanguageModelInfrastructure {
    static final String MODEL_NAME = "tinydolphin";

    OllamaStreamingChatModelIT() {
    }

    @Test
    void should_respect_numPredict() {
        int numPredict = 1;
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(OllamaStreamingChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).numPredict(Integer.valueOf(numPredict))).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = UserMessage.from((String)"What is the capital of Germany?");
        TestStreamingChatResponseHandler handler = new TestStreamingChatResponseHandler();
        model.chat(Collections.singletonList(userMessage), (StreamingChatResponseHandler)handler);
        ChatResponse response = handler.get();
        String answer = response.aiMessage().text();
        Assertions.assertThat((String)answer).doesNotContain(new CharSequence[]{"Berlin"});
        Assertions.assertThat((String)response.aiMessage().text()).isEqualTo(answer);
        ChatResponseMetadata metadata = response.metadata();
        Assertions.assertThat((String)metadata.modelName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((Comparable)metadata.finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        Assertions.assertThat((Integer)metadata.tokenUsage().outputTokenCount()).isBetween(Integer.valueOf(numPredict), Integer.valueOf(numPredict + 2));
    }

    @Test
    void should_generate_valid_json() {
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(OllamaStreamingChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).responseFormat(ResponseFormat.JSON)).temperature(Double.valueOf(0.0))).build();
        String userMessage = "Return JSON with two fields: name and age of John Doe, 42 years old.";
        TestStreamingChatResponseHandler handler = new TestStreamingChatResponseHandler();
        model.chat(userMessage, (StreamingChatResponseHandler)handler);
        ChatResponse response = handler.get();
        String answer = response.aiMessage().text();
        Assertions.assertThat((String)answer).isEqualToIgnoringWhitespace((CharSequence)"{\"name\": \"John Doe\", \"age\": 42}");
        Assertions.assertThat((String)response.aiMessage().text()).isEqualTo(answer);
        ChatResponseMetadata metadata = response.metadata();
        Assertions.assertThat((String)metadata.modelName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((Comparable)metadata.finishReason()).isEqualTo((Object)FinishReason.STOP);
    }

    @Test
    void should_propagate_failure_to_handler_onError() throws Exception {
        String wrongModelName = "banana";
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(OllamaStreamingChatModelIT.ollamaBaseUrl(ollama))).modelName(wrongModelName)).build();
        final CompletableFuture future = new CompletableFuture();
        model.chat("does not matter", new StreamingChatResponseHandler(){
            final /* synthetic */ OllamaStreamingChatModelIT this$0;
            {
                this.this$0 = this$0;
            }

            public void onPartialResponse(String partialResponse) {
                future.completeExceptionally(new Exception("onPartialResponse() should never be called"));
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                future.completeExceptionally(new Exception("onCompleteResponse() should never be called"));
            }

            public void onError(Throwable error) {
                future.complete(error);
            }
        });
        Throwable throwable = (Throwable)future.get();
        Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(ModelNotFoundException.class);
        Assertions.assertThat((String)throwable.getMessage()).contains(new CharSequence[]{"banana", "not found"});
        Assertions.assertThat((Throwable)throwable).hasCauseExactlyInstanceOf(HttpException.class);
        Assertions.assertThat((int)((HttpException)throwable.getCause()).statusCode()).isEqualTo(404);
    }

    @Test
    void should_return_set_capabilities() {
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(OllamaStreamingChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).supportedCapabilities(new Capability[]{Capability.RESPONSE_FORMAT_JSON_SCHEMA})).build();
        Assertions.assertThat((Collection)model.supportedCapabilities()).contains((Object[])new Capability[]{Capability.RESPONSE_FORMAT_JSON_SCHEMA});
    }

    @ParameterizedTest
    @ValueSource(ints={1, 10, 100, 500})
    void should_handle_timeout(int millis) throws Exception {
        Duration timeout = Duration.ofMillis(millis);
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(OllamaStreamingChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).timeout(timeout)).build();
        CompletableFuture<Throwable> futureError = new CompletableFuture<Throwable>();
        ErrorHandler handler = new ErrorHandler(futureError);
        model.chat("hi", (StreamingChatResponseHandler)handler);
        Throwable error = futureError.get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((Throwable)error).isExactlyInstanceOf(TimeoutException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"dev.langchain4j.model.ollama.OllamaChatModelIT#notSupportedContentTypesProvider"})
    void should_throw_when_not_supported_content_types_used(List<ContentType> contentTypes) {
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(OllamaStreamingChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).build();
        CompletableFuture<Throwable> futureError = new CompletableFuture<Throwable>();
        ErrorHandler handler = new ErrorHandler(futureError);
        UserMessage userMessage = OllamaChatModelIT.createUserMessageBasedOnContentTypes(contentTypes);
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedFeatureException.class, () -> OllamaStreamingChatModelIT.lambda$should_throw_when_not_supported_content_types_used$0((StreamingChatModel)model, userMessage, handler));
    }

    @ParameterizedTest
    @MethodSource(value={"dev.langchain4j.model.ollama.OllamaChatModelIT#supportedContentTypesProvider"})
    void should_not_throw_when_supported_content_types_used(List<ContentType> contentTypes) throws Exception {
        OllamaStreamingChatModel model = ((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)((OllamaStreamingChatModel.OllamaStreamingChatModelBuilder)OllamaStreamingChatModel.builder().baseUrl(OllamaStreamingChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).timeout(Duration.ofMillis(10L))).build();
        CompletableFuture<Throwable> futureError = new CompletableFuture<Throwable>();
        ErrorHandler handler = new ErrorHandler(futureError);
        UserMessage userMessage = OllamaChatModelIT.createUserMessageBasedOnContentTypes(contentTypes);
        model.chat(List.of(userMessage), (StreamingChatResponseHandler)handler);
        Throwable error = futureError.get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((Throwable)error).isExactlyInstanceOf(TimeoutException.class);
    }

    private static /* synthetic */ void lambda$should_throw_when_not_supported_content_types_used$0(StreamingChatModel model, UserMessage userMessage, StreamingChatResponseHandler handler) throws Throwable {
        model.chat(List.of(userMessage), handler);
    }

    private record ErrorHandler(CompletableFuture<Throwable> futureError) implements StreamingChatResponseHandler
    {
        public void onPartialResponse(String partialResponse) {
            this.futureError.completeExceptionally(new RuntimeException("onPartialResponse must not be called"));
        }

        public void onCompleteResponse(ChatResponse completeResponse) {
            this.futureError.completeExceptionally(new RuntimeException("onCompleteResponse must not be called"));
        }

        public void onError(Throwable error) {
            this.futureError.complete(error);
        }
    }
}

