/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaModel;
import dev.langchain4j.model.ollama.OllamaModelCard;
import dev.langchain4j.model.ollama.OllamaModels;
import dev.langchain4j.model.output.Response;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaModelsIT
extends AbstractOllamaLanguageModelInfrastructure {
    OllamaModels ollamaModels = OllamaModels.builder().baseUrl(OllamaModelsIT.ollamaBaseUrl(ollama)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).build();

    OllamaModelsIT() {
    }

    @Test
    void should_return_ollama_models_list() {
        Response response = this.ollamaModels.availableModels();
        List ollamaModels = (List)response.content();
        Assertions.assertThat((List)ollamaModels).isNotEmpty();
        for (OllamaModel ollamaModel : ollamaModels) {
            Assertions.assertThat((String)ollamaModel.getName()).isNotBlank();
            Assertions.assertThat((long)ollamaModel.getSize()).isPositive();
            Assertions.assertThat((String)ollamaModel.getDigest()).isNotBlank();
            Assertions.assertThat((Object)ollamaModel.getDetails()).isNotNull();
            Assertions.assertThat((String)ollamaModel.getModel()).isNotBlank();
            Assertions.assertThat((OffsetDateTime)ollamaModel.getModifiedAt()).isNotNull();
        }
    }

    @Test
    void should_return_ollama_model_info_for_given_ollama_model() {
        OllamaModel ollamaModel = OllamaModel.builder().name("tinydolphin").build();
        Response response = this.ollamaModels.modelCard(ollamaModel);
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getModelfile()).isNotBlank();
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getTemplate()).isNotBlank();
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getParameters()).isNotBlank();
        Assertions.assertThat((OffsetDateTime)((OllamaModelCard)response.content()).getModifiedAt()).isNotNull();
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getDetails().getFamily()).isEqualTo("llama");
        Assertions.assertThat((List)((OllamaModelCard)response.content()).getCapabilities()).contains((Object[])new String[]{"completion"});
    }

    @Test
    void should_return_ollama_model_info_for_given_ollama_model_name() {
        Response response = this.ollamaModels.modelCard("tinydolphin");
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getModelfile()).isNotBlank();
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getTemplate()).isNotBlank();
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getParameters()).isNotBlank();
        Assertions.assertThat((OffsetDateTime)((OllamaModelCard)response.content()).getModifiedAt()).isNotNull();
        Assertions.assertThat((int)((OllamaModelCard)response.content()).getModelInfo().keySet().size()).isPositive();
        Assertions.assertThat((Map)((OllamaModelCard)response.content()).getModelInfo()).containsKey((Object)"general.architecture");
        Assertions.assertThat((String)((OllamaModelCard)response.content()).getDetails().getFamily()).isEqualTo("llama");
    }

    @Test
    void should_return_list_of_running_models() {
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaModelsIT.ollamaBaseUrl(ollama))).modelName("tinydolphin")).temperature(Double.valueOf(0.0))).numPredict(Integer.valueOf(1))).build();
        model.chat("Tell a joke");
        Response response = this.ollamaModels.runningModels();
        Assertions.assertThat((List)((List)response.content())).anySatisfy(runningOllamaModel -> {
            Assertions.assertThat((String)runningOllamaModel.getName()).contains(new CharSequence[]{"tinydolphin"});
            Assertions.assertThat((String)runningOllamaModel.getDigest()).isNotBlank();
            Assertions.assertThat((OffsetDateTime)runningOllamaModel.getExpiresAt()).isNotNull();
        });
    }
}

