/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaLanguageModel;
import dev.langchain4j.model.output.Response;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaLanguageModelIT
extends AbstractOllamaLanguageModelInfrastructure {
    LanguageModel model = OllamaLanguageModel.builder().baseUrl(OllamaLanguageModelIT.ollamaBaseUrl(ollama)).modelName("tinydolphin").temperature(Double.valueOf(0.0)).build();

    OllamaLanguageModelIT() {
    }

    @Test
    void should_generate_answer() {
        String userMessage = "What is the capital of Germany?";
        Response response = this.model.generate(userMessage);
        Assertions.assertThat((String)((String)response.content())).contains(new CharSequence[]{"Berlin"});
    }

    @Test
    void should_respect_numPredict() {
        int numPredict = 1;
        OllamaLanguageModel model = OllamaLanguageModel.builder().baseUrl(OllamaLanguageModelIT.ollamaBaseUrl(ollama)).modelName("tinydolphin").numPredict(Integer.valueOf(numPredict)).temperature(Double.valueOf(0.0)).build();
        String prompt = "What is the capital of Germany?";
        Response response = model.generate(prompt);
        Assertions.assertThat((String)((String)response.content())).doesNotContain(new CharSequence[]{"Berlin"});
        Assertions.assertThat((Integer)response.tokenUsage().outputTokenCount()).isBetween(Integer.valueOf(numPredict), Integer.valueOf(numPredict + 2));
    }

    @Test
    void should_generate_valid_json() {
        OllamaLanguageModel model = OllamaLanguageModel.builder().baseUrl(OllamaLanguageModelIT.ollamaBaseUrl(ollama)).modelName("tinydolphin").responseFormat(ResponseFormat.JSON).temperature(Double.valueOf(0.0)).build();
        String userMessage = "Return JSON with two fields: name and age of John Doe, 42 years old.";
        Response response = model.generate(userMessage);
        Assertions.assertThat((String)((String)response.content())).isEqualToIgnoringWhitespace((CharSequence)"{\"name\": \"John Doe\", \"age\": 42}");
    }
}

