/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.github.dockerjava.api.DockerClient;
import java.util.List;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.utility.DockerImageName;

public class OllamaImage {
    public static final String OLLAMA_IMAGE = "ollama/ollama:latest";
    public static final String TINY_DOLPHIN_MODEL = "tinydolphin";
    public static final String LLAMA_3_1 = "llama3.1";
    public static final String LLAMA_3_2 = "llama3.2";
    public static final String LLAMA_3_2_VISION = "llama3.2-vision";
    public static final String QWEN3_06B = "qwen3:0.6b";
    public static final String ALL_MINILM_MODEL = "all-minilm";
    public static final String GRANITE_3_GUARDIAN = "granite3-guardian";

    public static String localOllamaImage(String modelName) {
        return String.format("tc-%s-%s", OLLAMA_IMAGE, modelName);
    }

    public static DockerImageName resolve(String baseImage, String localImageName) {
        DockerImageName dockerImageName = DockerImageName.parse((String)baseImage);
        DockerClient dockerClient = DockerClientFactory.instance().client();
        List images = (List)dockerClient.listImagesCmd().withReferenceFilter(localImageName).exec();
        if (images.isEmpty()) {
            return dockerImageName;
        }
        return DockerImageName.parse((String)localImageName).asCompatibleSubstituteFor(baseImage);
    }
}

