/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.ollama.AbstractOllamaEmbeddingModelInfrastructure;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaEmbeddingModel;
import dev.langchain4j.model.output.Response;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaEmbeddingModelIT
extends AbstractOllamaEmbeddingModelInfrastructure {
    EmbeddingModel model = OllamaEmbeddingModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama)).modelName("all-minilm").build();

    OllamaEmbeddingModelIT() {
    }

    @Test
    void should_embed() {
        String text = "hello world";
        Response response = this.model.embed(text);
        Assertions.assertThat((float[])((Embedding)response.content()).vector()).isNotEmpty();
        Assertions.assertThat((int)((Embedding)response.content()).dimension()).isEqualTo(this.model.dimension());
        Assertions.assertThat((Object)response.tokenUsage()).isNull();
        Assertions.assertThat((Comparable)response.finishReason()).isNull();
    }

    @Test
    void should_embed_multiple_segments() {
        List<TextSegment> segments = Arrays.asList(TextSegment.from((String)"hello"), TextSegment.from((String)"world"));
        Response response = this.model.embedAll(segments);
        Assertions.assertThat((List)((List)response.content())).hasSize(2);
        Assertions.assertThat((int)((Embedding)((List)response.content()).get(0)).dimension()).isEqualTo(this.model.dimension());
        Assertions.assertThat((int)((Embedding)((List)response.content()).get(1)).dimension()).isEqualTo(this.model.dimension());
        Assertions.assertThat((Object)response.tokenUsage()).isNull();
        Assertions.assertThat((Comparable)response.finishReason()).isNull();
    }

    @Test
    void should_return_correct_dimension() {
        String text = "hello world";
        Response response = this.model.embed(text);
        Assertions.assertThat((int)this.model.dimension()).isEqualTo(((Embedding)response.content()).dimension());
    }
}

