/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import dev.langchain4j.model.ollama.OllamaDateDeserializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class OllamaDateDeserializerTest {
    @Mock
    JsonParser jsonParser;
    @Mock
    DeserializationContext deserializationContext;

    OllamaDateDeserializerTest() {
    }

    @Test
    void should_trim_nanoseconds_and_deserialize_utc_date() throws IOException {
        Mockito.when((Object)this.jsonParser.getText()).thenReturn((Object)"2024-09-04T15:21:17.521503059Z");
        OffsetDateTime offsetDateTime = new OllamaDateDeserializer().deserialize(this.jsonParser, this.deserializationContext);
        Assertions.assertThat((Comparable)offsetDateTime.getOffset()).isEqualTo((Object)ZoneOffset.UTC);
        Assertions.assertThat((int)offsetDateTime.getYear()).isEqualTo(2024);
        Assertions.assertThat((int)offsetDateTime.getMonthValue()).isEqualTo(9);
        Assertions.assertThat((int)offsetDateTime.getHour()).isEqualTo(15);
        Assertions.assertThat((int)offsetDateTime.getNano()).isEqualTo(0);
    }

    @Test
    void should_trim_nanoseconds_and_deserialize_utc_date_with_offset() throws IOException {
        Mockito.when((Object)this.jsonParser.getText()).thenReturn((Object)"2024-08-04T00:54:54.764563036+02:00");
        OffsetDateTime offsetDateTime = new OllamaDateDeserializer().deserialize(this.jsonParser, this.deserializationContext);
        Assertions.assertThat((Comparable)offsetDateTime.getOffset()).isEqualTo((Object)ZoneOffset.ofHours(2));
        Assertions.assertThat((int)offsetDateTime.getYear()).isEqualTo(2024);
        Assertions.assertThat((int)offsetDateTime.getMonthValue()).isEqualTo(8);
        Assertions.assertThat((int)offsetDateTime.getHour()).isEqualTo(0);
        Assertions.assertThat((int)offsetDateTime.getNano()).isEqualTo(0);
    }

    @Test
    void should_trim_nanoseconds_and_deserialize_utc_date_with_negative_offset() throws IOException {
        Mockito.when((Object)this.jsonParser.getText()).thenReturn((Object)"2024-06-15T05:18:13.974383393-07:00");
        OffsetDateTime offsetDateTime = new OllamaDateDeserializer().deserialize(this.jsonParser, this.deserializationContext);
        Assertions.assertThat((Comparable)offsetDateTime.getOffset()).isEqualTo((Object)ZoneOffset.ofHours(-7));
        Assertions.assertThat((int)offsetDateTime.getYear()).isEqualTo(2024);
        Assertions.assertThat((int)offsetDateTime.getMonthValue()).isEqualTo(6);
        Assertions.assertThat((int)offsetDateTime.getHour()).isEqualTo(5);
        Assertions.assertThat((int)offsetDateTime.getNano()).isEqualTo(0);
    }
}

