/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.CustomMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.LC4jOllamaContainer;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaImage;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaCustomMessageChatModelIT
extends AbstractOllamaLanguageModelInfrastructure {
    private static final String MODEL_NAME = "granite3-guardian";
    ChatModel ollamaChatModel = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaCustomMessageChatModelIT.ollamaBaseUrl(ollama))).modelName("granite3-guardian")).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();

    OllamaCustomMessageChatModelIT() {
    }

    @Test
    void should_generate_response_with_custom_message() {
        String retrievedContext = "One significant part of treaty making is that signing a treaty implies recognition that the other side is a sovereign state and that the agreement being considered is enforceable under international law. Hence, nations can be very careful about terming an agreement to be a treaty. For example, within the United States, agreements between states are compacts and agreements between states and the federal government or between agencies of the government are memoranda of understanding.";
        List<CustomMessage> messages = List.of(SystemMessage.from((String)"context_relevance"), UserMessage.from((String)"What is the history of treaty making?"), CustomMessage.from(Map.of("role", "context", "content", retrievedContext)));
        ChatResponse chatResponse = this.ollamaChatModel.chat(ChatRequest.builder().messages(messages).build());
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isEqualTo("Yes");
        retrievedContext = "Eat (1964) is a 45-minute underground film created by Andy Warhol and featuring painter Robert Indiana, filmed on Sunday, February 2, 1964, in Indiana's studio. The film was first shown by Jonas Mekas on July 16, 1964, at the Washington Square Gallery at 530 West Broadway.\nJonas Mekas (December 24, 1922 \u2013 January 23, 2019) was a Lithuanian-American filmmaker, poet, and artist who has been called \"the godfather of American avant-garde cinema\". Mekas's work has been exhibited in museums and at festivals worldwide.";
        messages = List.of(SystemMessage.from((String)"groundedness"), CustomMessage.from(Map.of("role", "context", "content", retrievedContext)), AiMessage.from((String)"The film Eat was first shown by Jonas Mekas on December 24, 1922 at the Washington Square Gallery at 530 West Broadway."));
        chatResponse = this.ollamaChatModel.chat(ChatRequest.builder().messages(messages).build());
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isEqualTo("Yes");
    }

    @Test
    void should_generate_response_without_custom_message() {
        List<AiMessage> messages = List.of(SystemMessage.from((String)"answer_relevance"), UserMessage.from((String)"In what month did the AFL season originally begin?"), AiMessage.from((String)"The AFL season now begins in March."));
        ChatResponse chatResponse = this.ollamaChatModel.chat(ChatRequest.builder().messages(messages).build());
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isEqualTo("Yes");
        messages = List.of(SystemMessage.from((String)"answer_relevance"), UserMessage.from((String)"In what month did the AFL season originally begin?"), AiMessage.from((String)"The AFL season originally began in January."));
        chatResponse = this.ollamaChatModel.chat(ChatRequest.builder().messages(messages).build());
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isEqualTo("No");
    }

    static {
        if (Utils.isNullOrEmpty((String)OLLAMA_BASE_URL)) {
            String localOllamaImage = OllamaImage.localOllamaImage(MODEL_NAME);
            ollama = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImage)).withModel(MODEL_NAME);
            ollama.start();
            ollama.commitToImage(localOllamaImage);
        }
    }
}

