/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.AbstractOllamaThinkingModelInfrastructure;
import dev.langchain4j.model.ollama.Message;
import dev.langchain4j.model.ollama.OllamaChatRequest;
import dev.langchain4j.model.ollama.OllamaChatResponse;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.Role;
import java.time.Duration;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaClientThinkingIT
extends AbstractOllamaThinkingModelInfrastructure {
    Message whySkyIsBlueMessage = Message.builder().role(Role.USER).content("Why sky is blue?").build();
    OllamaClient ollamaClient = OllamaClient.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama)).logRequests(Boolean.valueOf(true)).logResponses(Boolean.valueOf(true)).timeout(Duration.ofMinutes(1L)).build();

    OllamaClientThinkingIT() {
    }

    @Test
    void should_respond_with_thinking_when_think_is_true() {
        OllamaChatResponse ollamaChatResponse = this.ollamaClient.chat(OllamaChatRequest.builder().think(Boolean.valueOf(true)).stream(Boolean.valueOf(false)).model("qwen3:0.6b").messages(List.of(this.whySkyIsBlueMessage)).build());
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getThinking()).isNotEmpty();
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getContent()).isNotEmpty();
    }

    @Test
    void should_respond_with_no_thinking_when_think_is_false() {
        OllamaChatResponse ollamaChatResponse = this.ollamaClient.chat(OllamaChatRequest.builder().think(Boolean.valueOf(false)).stream(Boolean.valueOf(false)).model("qwen3:0.6b").messages(List.of(this.whySkyIsBlueMessage)).build());
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getThinking()).isNullOrEmpty();
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getContent()).isNotEmpty();
    }

    @Test
    void should_respond_with_thinking_block_in_content_when_think_is_not_set() {
        OllamaChatResponse ollamaChatResponse = this.ollamaClient.chat(OllamaChatRequest.builder().stream(Boolean.valueOf(false)).model("qwen3:0.6b").messages(List.of(this.whySkyIsBlueMessage)).build());
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getThinking()).isNotEmpty();
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getContent()).isNotEmpty();
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getContent()).doesNotContain(new CharSequence[]{"<think>"});
        Assertions.assertThat((String)ollamaChatResponse.getMessage().getContent()).doesNotContain(new CharSequence[]{"</think>"});
    }
}

