/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.ModelsListResponse;
import dev.langchain4j.model.ollama.OllamaClient;
import dev.langchain4j.model.ollama.OllamaModel;
import dev.langchain4j.model.ollama.OllamaModelCard;
import dev.langchain4j.model.ollama.ShowModelInformationRequest;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaClientIT
extends AbstractOllamaLanguageModelInfrastructure {
    OllamaClientIT() {
    }

    @Test
    void should_respond_with_models_list() {
        OllamaClient ollamaClient = OllamaClient.builder().baseUrl(OllamaClientIT.ollamaBaseUrl(ollama)).timeout(Duration.ofMinutes(1L)).build();
        ModelsListResponse modelListResponse = ollamaClient.listModels();
        List ollamaModels = modelListResponse.getModels();
        Assertions.assertThat((List)ollamaModels).isNotEmpty();
        for (OllamaModel ollamaModel : ollamaModels) {
            Assertions.assertThat((String)ollamaModel.getName()).isNotBlank();
            Assertions.assertThat((long)ollamaModel.getSize()).isPositive();
            Assertions.assertThat((String)ollamaModel.getDigest()).isNotBlank();
            Assertions.assertThat((Object)ollamaModel.getDetails()).isNotNull();
            Assertions.assertThat((String)ollamaModel.getModel()).isNotBlank();
            Assertions.assertThat((OffsetDateTime)ollamaModel.getModifiedAt()).isNotNull();
        }
    }

    @Test
    void should_respond_with_model_information() {
        OllamaClient ollamaClient = OllamaClient.builder().baseUrl(OllamaClientIT.ollamaBaseUrl(ollama)).timeout(Duration.ofMinutes(1L)).build();
        OllamaModelCard modelDetailsResponse = ollamaClient.showInformation(ShowModelInformationRequest.builder().name("tinydolphin:latest").build());
        Assertions.assertThat((String)modelDetailsResponse.getModelfile()).contains(new CharSequence[]{"# Modelfile generated by \"ollama show\""});
        Assertions.assertThat((String)modelDetailsResponse.getParameters()).contains(new CharSequence[]{"stop"});
        Assertions.assertThat((String)modelDetailsResponse.getTemplate()).contains(new CharSequence[]{"<|im_start|>"});
        Assertions.assertThat((String)modelDetailsResponse.getDetails().getFormat()).isEqualTo("gguf");
        Assertions.assertThat((String)modelDetailsResponse.getDetails().getFamily()).isEqualTo("llama");
    }
}

