/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.JsonTestUtils;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.MockHttpClientBuilder;
import dev.langchain4j.http.client.SpyingHttpClient;
import dev.langchain4j.http.client.jdk.JdkHttpClient;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.AbstractOllamaThinkingModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaChatModel;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OllamaChatModelThinkingIT
extends AbstractOllamaThinkingModelInfrastructure {
    private final SpyingHttpClient spyingHttpClient = new SpyingHttpClient((HttpClient)JdkHttpClient.builder().build());

    OllamaChatModelThinkingIT() {
    }

    @Test
    void should_think_and_return_thinking() {
        boolean think = true;
        boolean returnThinking = true;
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().httpClientBuilder((HttpClientBuilder)new MockHttpClientBuilder((HttpClient)this.spyingHttpClient))).baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(Boolean.valueOf(think))).returnThinking(Boolean.valueOf(returnThinking))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = UserMessage.from((String)"What is the capital of Germany?");
        ChatResponse chatResponse = model.chat(new ChatMessage[]{userMessage});
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        Assertions.assertThat((String)aiMessage.thinking()).isNotBlank();
        UserMessage userMessage2 = UserMessage.from((String)"What is the capital of France?");
        ChatResponse chatResponse2 = model.chat(new ChatMessage[]{userMessage, aiMessage, userMessage2});
        AiMessage aiMessage2 = chatResponse2.aiMessage();
        Assertions.assertThat((String)aiMessage2.text()).containsIgnoringCase((CharSequence)"Paris");
        Assertions.assertThat((String)aiMessage2.thinking()).isNotBlank();
        List httpRequests = this.spyingHttpClient.requests();
        Assertions.assertThat((List)httpRequests).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((HttpRequest)httpRequests.get(1)).body()).contains(new CharSequence[]{JsonTestUtils.jsonify((String)aiMessage.text())})).doesNotContain(new CharSequence[]{JsonTestUtils.jsonify((String)aiMessage.thinking())});
    }

    @Test
    void should_think_and_NOT_return_thinking() {
        boolean think = true;
        boolean returnThinking = false;
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(Boolean.valueOf(think))).returnThinking(Boolean.valueOf(returnThinking))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = UserMessage.from((String)"What is the capital of Germany?");
        ChatResponse chatResponse = model.chat(new ChatMessage[]{userMessage});
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        Assertions.assertThat((String)aiMessage.thinking()).isNull();
    }

    @Test
    void should_NOT_think() {
        boolean think = false;
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(Boolean.valueOf(think))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = UserMessage.from((String)"What is the capital of Germany?");
        ChatResponse chatResponse = model.chat(new ChatMessage[]{userMessage});
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        Assertions.assertThat((String)aiMessage.thinking()).isNull();
    }

    @Test
    void should_think_and_return_thinking_when_think_is_not_set() {
        Boolean think = null;
        boolean returnThinking = true;
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("qwen3:0.6b")).think(think)).returnThinking(Boolean.valueOf(returnThinking))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = UserMessage.from((String)"What is the capital of Germany?");
        ChatResponse chatResponse = model.chat(new ChatMessage[]{userMessage});
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin")).doesNotContain(new CharSequence[]{"<think>", "</think>"});
        Assertions.assertThat((String)aiMessage.thinking()).isNotEmpty();
    }
}

