/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.exception.ModelNotFoundException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.common.AbstractChatModelListenerIT;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.LC4jOllamaContainer;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.ollama.OllamaImage;
import java.util.Collections;

class OllamaChatModelListenerIT
extends AbstractChatModelListenerIT {
    private static final String MODEL_NAME = "llama3.1";
    private static LC4jOllamaContainer ollama;

    OllamaChatModelListenerIT() {
    }

    protected ChatModel createModel(ChatModelListener listener) {
        return ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName(this.modelName())).temperature(this.temperature())).topP(this.topP())).numPredict(this.maxTokens())).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).listeners(Collections.singletonList(listener))).build();
    }

    protected String modelName() {
        return MODEL_NAME;
    }

    protected ChatModel createFailingModel(ChatModelListener listener) {
        return ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(AbstractOllamaLanguageModelInfrastructure.ollamaBaseUrl(ollama))).modelName("banana")).maxRetries(Integer.valueOf(0)).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).listeners(Collections.singletonList(listener))).build();
    }

    protected Class<? extends Exception> expectedExceptionClass() {
        return ModelNotFoundException.class;
    }

    protected boolean assertResponseId() {
        return false;
    }

    static {
        if (Utils.isNullOrEmpty((String)AbstractOllamaLanguageModelInfrastructure.OLLAMA_BASE_URL)) {
            String localOllamaImage = OllamaImage.localOllamaImage(MODEL_NAME);
            ollama = new LC4jOllamaContainer(OllamaImage.resolve("ollama/ollama:latest", localOllamaImage)).withModel(MODEL_NAME);
            ollama.start();
            ollama.commitToImage(localOllamaImage);
        }
    }
}

